/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.partition.impl;

import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.primitive.partition.ManagedPartitionGroup;
import io.atomix.primitive.partition.ManagedPartitionService;
import io.atomix.primitive.partition.PartitionManagementService;
import io.atomix.primitive.partition.PartitionService;
import io.atomix.primitive.partition.impl.DefaultPartitionManagementService;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPartitionService
implements ManagedPartitionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPartitionService.class);
    private final ClusterMembershipService clusterMembershipService;
    private final ClusterCommunicationService communicationService;
    private volatile PartitionManagementService partitionManagementService;
    private final ManagedPartitionGroup group;
    private final AtomicBoolean started = new AtomicBoolean();

    public DefaultPartitionService(ClusterMembershipService membershipService, ClusterCommunicationService messagingService, ManagedPartitionGroup group) {
        this.clusterMembershipService = membershipService;
        this.communicationService = messagingService;
        this.group = group;
    }

    @Override
    public ManagedPartitionGroup getPartitionGroup() {
        return this.group;
    }

    public CompletableFuture<PartitionService> start() {
        if (this.started.compareAndSet(false, true)) {
            this.partitionManagementService = new DefaultPartitionManagementService(this.clusterMembershipService, this.communicationService);
            CompletableFuture<Object> startStepFuture = this.group != null ? this.group.join(this.partitionManagementService) : CompletableFuture.completedFuture(null);
            return startStepFuture.thenApply(v -> {
                LOGGER.debug("Started {}", this.getClass());
                this.started.set(true);
                return this;
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public CompletableFuture<Void> stop() {
        CompletableFuture<Object> stopStepFuture = this.group != null ? this.group.close() : CompletableFuture.completedFuture(null);
        return ((CompletableFuture)stopStepFuture.exceptionally(throwable -> {
            LOGGER.error("Failed closing partition group(s)", throwable);
            return null;
        })).thenRun(() -> {
            LOGGER.info("Stopped");
            this.started.set(false);
        });
    }
}

