/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xcontent.support.filtering;

import java.util.ArrayList;
import java.util.Set;
import org.elasticsearch.core.Glob;

public class FilterPath {
    public static final FilterPath EMPTY = new FilterPath();
    private final String filter;
    private final String segment;
    private final FilterPath next;
    private final boolean simpleWildcard;
    private final boolean doubleWildcard;

    protected FilterPath(String filter, String segment, FilterPath next) {
        this.filter = filter;
        this.segment = segment;
        this.next = next;
        this.simpleWildcard = segment != null && segment.length() == 1 && segment.charAt(0) == '*';
        this.doubleWildcard = segment != null && segment.length() == 2 && segment.charAt(0) == '*' && segment.charAt(1) == '*';
    }

    private FilterPath() {
        this("<empty>", "", null);
    }

    public FilterPath matchProperty(String name) {
        if (this.next != null && (this.simpleWildcard || this.doubleWildcard || Glob.globMatch((String)this.segment, (String)name))) {
            return this.next;
        }
        return null;
    }

    public boolean matches() {
        return this.next == null;
    }

    public boolean isDoubleWildcard() {
        return this.doubleWildcard;
    }

    public boolean hasDoubleWildcard() {
        if (this.filter == null) {
            return false;
        }
        return this.filter.indexOf("**") >= 0;
    }

    public boolean isSimpleWildcard() {
        return this.simpleWildcard;
    }

    public String getSegment() {
        return this.segment;
    }

    public FilterPath getNext() {
        return this.next;
    }

    public static FilterPath[] compile(Set<String> filters) {
        if (filters == null || filters.isEmpty()) {
            return null;
        }
        ArrayList<FilterPath> paths = new ArrayList<FilterPath>();
        for (String filter : filters) {
            if (filter == null || (filter = filter.trim()).length() <= 0) continue;
            paths.add(FilterPath.parse(filter, filter));
        }
        return paths.toArray(new FilterPath[paths.size()]);
    }

    private static FilterPath parse(String filter, String segment) {
        int end = segment.length();
        int i = 0;
        while (i < end) {
            char c = segment.charAt(i);
            if (c == '.') {
                String current = segment.substring(0, i).replaceAll("\\\\.", ".");
                return new FilterPath(filter, current, FilterPath.parse(filter, segment.substring(i + 1)));
            }
            if (c != '\\' || ++i >= end || segment.charAt(i) != '.') continue;
            ++i;
        }
        return new FilterPath(filter, segment.replaceAll("\\\\.", "."), EMPTY);
    }

    public String toString() {
        return "FilterPath [filter=" + this.filter + ", segment=" + this.segment + "]";
    }
}

