/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.concurrent;

import io.atomix.utils.concurrent.AtomixFuture;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Futures {
    public static <T> T get(Future<T> future) {
        return Futures.get(future, 30L, TimeUnit.SECONDS);
    }

    public static <T> T get(Future<T> future, long timeout, TimeUnit timeUnit) {
        try {
            return future.get(timeout, timeUnit);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> CompletableFuture<T> completedFuture(T result) {
        return CompletableFuture.completedFuture(result);
    }

    public static <T> CompletableFuture<T> exceptionalFuture(Throwable t) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(t);
        return future;
    }

    public static <T> CompletableFuture<Stream<T>> allOf(Stream<CompletableFuture<T>> futures) {
        CompletableFuture[] futuresArray = (CompletableFuture[])futures.toArray(CompletableFuture[]::new);
        return AtomixFuture.wrap(CompletableFuture.allOf(futuresArray).thenApply(v -> Stream.of(futuresArray).map(CompletableFuture::join)));
    }

    public static <T> CompletableFuture<List<T>> allOf(List<CompletableFuture<T>> futures) {
        return AtomixFuture.wrap(CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenApply(v -> futures.stream().map(CompletableFuture::join).collect(Collectors.toList())));
    }

    public static <T> CompletableFuture<T> allOf(List<CompletableFuture<T>> futures, BinaryOperator<T> reducer, T emptyValue) {
        return Futures.allOf(futures).thenApply(resultList -> resultList.stream().reduce(reducer).orElse(emptyValue));
    }
}

