/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.shared;

import io.camunda.zeebe.shared.management.ActorClockService;
import io.camunda.zeebe.shared.management.ControlledActorClockService;
import io.camunda.zeebe.util.sched.clock.ActorClock;
import io.camunda.zeebe.util.sched.clock.ControlledActorClock;
import io.camunda.zeebe.util.sched.clock.DefaultActorClock;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.ConstructorBinding;
import org.springframework.boot.context.properties.bind.DefaultValue;
import org.springframework.context.annotation.Bean;
import org.springframework.web.context.annotation.ApplicationScope;

@ConfigurationProperties(value="zeebe.clock")
public final class ActorClockConfiguration {
    private final ActorClock clock;
    private final ActorClockService service;

    @ConstructorBinding
    public ActorClockConfiguration(@DefaultValue(value={"false"}) boolean controlled) {
        if (controlled) {
            ControlledActorClock controlledClock = new ControlledActorClock();
            this.service = new ControlledActorClockService(controlledClock);
            this.clock = controlledClock;
        } else {
            this.clock = new DefaultActorClock();
            this.service = () -> ((ActorClock)this.clock).getTimeMillis();
        }
    }

    @Bean
    @ApplicationScope
    public ActorClock getClock() {
        return this.clock;
    }

    @Bean
    @ApplicationScope
    public ActorClockService getClockService() {
        return this.service;
    }
}

