/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.journal.file.record;

import io.camunda.zeebe.journal.JournalException;
import io.camunda.zeebe.journal.JournalRecord;
import io.camunda.zeebe.journal.file.ChecksumGenerator;
import io.camunda.zeebe.journal.file.record.CorruptedLogException;
import io.camunda.zeebe.journal.file.record.JournalRecordSerializer;
import io.camunda.zeebe.journal.file.record.PersistedJournalRecord;
import io.camunda.zeebe.journal.file.record.RecordData;
import io.camunda.zeebe.journal.file.record.RecordMetadata;
import java.nio.ByteBuffer;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class JournalRecordReaderUtil {
    private final JournalRecordSerializer serializer;
    private final ChecksumGenerator checksumGenerator = new ChecksumGenerator();

    public JournalRecordReaderUtil(JournalRecordSerializer serializer) {
        this.serializer = serializer;
    }

    public JournalRecord read(ByteBuffer buffer, long expectedIndex) {
        buffer.mark();
        if (buffer.position() + this.serializer.getMetadataLength() > buffer.limit()) {
            throw new CorruptedLogException("Expected to read a record, but reached the end of the segment.");
        }
        int startPosition = buffer.position();
        UnsafeBuffer directBuffer = new UnsafeBuffer(buffer.slice());
        RecordMetadata metadata = this.serializer.readMetadata((DirectBuffer)directBuffer, 0);
        int metadataLength = this.serializer.getMetadataLength((DirectBuffer)directBuffer, 0);
        int recordLength = metadata.length();
        if (buffer.position() + metadataLength + recordLength > buffer.limit()) {
            throw new CorruptedLogException(String.format("Expected to read a record at position %d, with metadata %s, but reached the end of the segment.", buffer.position(), metadata));
        }
        long checksum = this.checksumGenerator.compute(buffer, startPosition + metadataLength, recordLength);
        if (checksum != metadata.checksum()) {
            buffer.reset();
            throw new CorruptedLogException("Record doesn't match checksum. Log segment may be corrupted.");
        }
        RecordData record = this.serializer.readData((DirectBuffer)directBuffer, metadataLength, recordLength);
        if (record != null && expectedIndex != record.index()) {
            buffer.reset();
            throw new JournalException.InvalidIndex(String.format("Expected to read a record with next index %d, but found %d", expectedIndex, record.index()));
        }
        buffer.position(startPosition + metadataLength + recordLength);
        return new PersistedJournalRecord(metadata, record);
    }
}

