/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client;

import io.camunda.zeebe.client.ZeebeClientBuilder;
import io.camunda.zeebe.client.ZeebeClientCloudBuilderStep1;
import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.api.command.ActivateJobsCommandStep1;
import io.camunda.zeebe.client.api.command.CancelProcessInstanceCommandStep1;
import io.camunda.zeebe.client.api.command.CreateProcessInstanceCommandStep1;
import io.camunda.zeebe.client.api.command.DeployProcessCommandStep1;
import io.camunda.zeebe.client.api.command.PublishMessageCommandStep1;
import io.camunda.zeebe.client.api.command.ResolveIncidentCommandStep1;
import io.camunda.zeebe.client.api.command.SetVariablesCommandStep1;
import io.camunda.zeebe.client.api.command.TopologyRequestStep1;
import io.camunda.zeebe.client.api.command.UpdateRetriesJobCommandStep1;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.client.api.worker.JobWorkerBuilderStep1;
import io.camunda.zeebe.client.impl.ZeebeClientBuilderImpl;
import io.camunda.zeebe.client.impl.ZeebeClientCloudBuilderImpl;
import io.camunda.zeebe.client.impl.ZeebeClientImpl;

public interface ZeebeClient
extends AutoCloseable,
JobClient {
    public static ZeebeClient newClient() {
        return ZeebeClient.newClientBuilder().build();
    }

    public static ZeebeClient newClient(ZeebeClientConfiguration configuration) {
        return new ZeebeClientImpl(configuration);
    }

    public static ZeebeClientBuilder newClientBuilder() {
        return new ZeebeClientBuilderImpl();
    }

    public static ZeebeClientCloudBuilderStep1 newCloudClientBuilder() {
        return new ZeebeClientCloudBuilderImpl();
    }

    public TopologyRequestStep1 newTopologyRequest();

    public ZeebeClientConfiguration getConfiguration();

    @Override
    public void close();

    public DeployProcessCommandStep1 newDeployCommand();

    public CreateProcessInstanceCommandStep1 newCreateInstanceCommand();

    public CancelProcessInstanceCommandStep1 newCancelInstanceCommand(long var1);

    public SetVariablesCommandStep1 newSetVariablesCommand(long var1);

    public PublishMessageCommandStep1 newPublishMessageCommand();

    public ResolveIncidentCommandStep1 newResolveIncidentCommand(long var1);

    public UpdateRetriesJobCommandStep1 newUpdateRetriesCommand(long var1);

    public UpdateRetriesJobCommandStep1 newUpdateRetriesCommand(ActivatedJob var1);

    public JobWorkerBuilderStep1 newWorker();

    public ActivateJobsCommandStep1 newActivateJobsCommand();
}

