/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.job;

import io.camunda.zeebe.gateway.Loggers;
import io.camunda.zeebe.gateway.RequestMapper;
import io.camunda.zeebe.gateway.grpc.ServerStreamObserver;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerActivateJobsRequest;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.camunda.zeebe.util.sched.ScheduledTimer;
import java.time.Duration;
import java.util.Objects;
import org.slf4j.Logger;

public final class LongPollingActivateJobsRequest {
    private static final Logger LOG = Loggers.GATEWAY_LOGGER;
    private final long requestId;
    private final BrokerActivateJobsRequest request;
    private final ServerStreamObserver<GatewayOuterClass.ActivateJobsResponse> responseObserver;
    private final String jobType;
    private final String worker;
    private final int maxJobsToActivate;
    private final Duration longPollingTimeout;
    private ScheduledTimer scheduledTimer;
    private boolean isTimedOut;
    private boolean isCompleted;

    public LongPollingActivateJobsRequest(long requestId, GatewayOuterClass.ActivateJobsRequest request, ServerStreamObserver<GatewayOuterClass.ActivateJobsResponse> responseObserver) {
        this(requestId, RequestMapper.toActivateJobsRequest(request), responseObserver, request.getType(), request.getWorker(), request.getMaxJobsToActivate(), request.getRequestTimeout());
    }

    private LongPollingActivateJobsRequest(long requestId, BrokerActivateJobsRequest request, ServerStreamObserver<GatewayOuterClass.ActivateJobsResponse> responseObserver, String jobType, String worker, int maxJobsToActivate, long longPollingTimeout) {
        this.requestId = requestId;
        this.request = request;
        this.responseObserver = responseObserver;
        this.jobType = jobType;
        this.worker = worker;
        this.maxJobsToActivate = maxJobsToActivate;
        this.longPollingTimeout = longPollingTimeout == 0L ? null : Duration.ofMillis(longPollingTimeout);
    }

    public void complete() {
        if (this.isCompleted() || this.isCanceled()) {
            return;
        }
        this.cancelTimerIfScheduled();
        try {
            this.responseObserver.onCompleted();
        }
        catch (Exception e) {
            LOG.warn("Failed to complete {}", (Object)this.request, (Object)e);
        }
        this.isCompleted = true;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public void onResponse(GatewayOuterClass.ActivateJobsResponse grpcResponse) {
        if (!this.isCompleted() && !this.isCanceled()) {
            try {
                this.responseObserver.onNext(grpcResponse);
            }
            catch (Exception e) {
                LOG.warn("Failed to send response to client.", (Throwable)e);
            }
        }
    }

    public void onError(Throwable error) {
        if (this.isCompleted() || this.isCanceled()) {
            return;
        }
        this.cancelTimerIfScheduled();
        try {
            this.responseObserver.onError(error);
        }
        catch (Exception e) {
            LOG.warn("Failed to send response to client.", (Throwable)e);
        }
    }

    public void timeout() {
        this.complete();
        this.isTimedOut = true;
    }

    public boolean isCanceled() {
        return this.responseObserver.isCancelled();
    }

    public BrokerActivateJobsRequest getRequest() {
        return this.request;
    }

    public ServerStreamObserver<GatewayOuterClass.ActivateJobsResponse> getResponseObserver() {
        return this.responseObserver;
    }

    public String getType() {
        return this.jobType;
    }

    public String getWorker() {
        return this.worker;
    }

    public int getMaxJobsToActivate() {
        return this.maxJobsToActivate;
    }

    public void setScheduledTimer(ScheduledTimer scheduledTimer) {
        this.scheduledTimer = scheduledTimer;
    }

    public boolean hasScheduledTimer() {
        return this.scheduledTimer != null;
    }

    public boolean isTimedOut() {
        return this.isTimedOut;
    }

    public Duration getLongPollingTimeout(Duration defaultTimeout) {
        if (this.longPollingTimeout == null) {
            return defaultTimeout;
        }
        return this.longPollingTimeout;
    }

    public boolean isLongPollingDisabled() {
        return this.longPollingTimeout != null && this.longPollingTimeout.isNegative();
    }

    private void cancelTimerIfScheduled() {
        if (this.hasScheduledTimer()) {
            this.scheduledTimer.cancel();
            this.scheduledTimer = null;
        }
    }

    public int hashCode() {
        return Objects.hash(this.jobType, this.maxJobsToActivate, this.requestId, this.worker);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LongPollingActivateJobsRequest other = (LongPollingActivateJobsRequest)obj;
        return Objects.equals(this.jobType, other.jobType) && this.maxJobsToActivate == other.maxJobsToActivate && this.requestId == other.requestId && Objects.equals(this.worker, other.worker);
    }
}

