/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.admin;

import io.camunda.zeebe.gateway.impl.broker.request.BrokerRequest;
import io.camunda.zeebe.gateway.impl.broker.response.BrokerResponse;
import io.camunda.zeebe.protocol.impl.encoding.AdminRequest;
import io.camunda.zeebe.protocol.impl.encoding.AdminResponse;
import io.camunda.zeebe.protocol.record.AdminRequestType;
import io.camunda.zeebe.transport.RequestType;
import io.camunda.zeebe.util.buffer.BufferWriter;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class BrokerAdminRequest
extends BrokerRequest<Void> {
    private final AdminRequest request = new AdminRequest();
    private final AdminResponse response = new AdminResponse();

    public BrokerAdminRequest() {
        super(0, 41);
    }

    public void stepDownIfNotPrimary() {
        this.request.setType(AdminRequestType.STEP_DOWN_IF_NOT_PRIMARY);
    }

    public int getPartitionId() {
        return this.request.getPartitionId();
    }

    @Override
    public void setPartitionId(int partitionId) {
        this.request.setPartitionId(partitionId);
    }

    @Override
    public boolean addressesSpecificPartition() {
        return true;
    }

    @Override
    public boolean requiresPartitionId() {
        return true;
    }

    @Override
    public BufferWriter getRequestWriter() {
        return null;
    }

    @Override
    protected void setSerializedValue(DirectBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void wrapResponse(DirectBuffer buffer) {
        this.response.wrap(buffer, 0, buffer.capacity());
    }

    @Override
    protected BrokerResponse<Void> readResponse() {
        return new BrokerResponse<Object>(null);
    }

    @Override
    protected Void toResponseDto(DirectBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getType() {
        return "Admin#" + this.request.getType();
    }

    public RequestType getRequestType() {
        return RequestType.ADMIN;
    }

    public int getLength() {
        return this.request.getLength();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.request.write(buffer, offset);
    }
}

