/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.impl.job;

import com.google.rpc.Status;
import io.camunda.zeebe.gateway.Loggers;
import io.camunda.zeebe.gateway.grpc.ServerStreamObserver;
import io.camunda.zeebe.gateway.impl.broker.BrokerClient;
import io.camunda.zeebe.gateway.impl.broker.cluster.BrokerClusterState;
import io.camunda.zeebe.gateway.impl.job.ActivateJobsHandler;
import io.camunda.zeebe.gateway.impl.job.InFlightLongPollingActivateJobsRequestsState;
import io.camunda.zeebe.gateway.impl.job.InflightActivateJobsRequest;
import io.camunda.zeebe.gateway.impl.job.RoundRobinActivateJobsHandler;
import io.camunda.zeebe.gateway.metrics.LongPollingMetrics;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.camunda.zeebe.util.sched.ActorControl;
import io.camunda.zeebe.util.sched.ScheduledTimer;
import io.camunda.zeebe.util.sched.clock.ActorClock;
import io.grpc.protobuf.StatusProto;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.slf4j.Logger;

public final class LongPollingActivateJobsHandler
implements ActivateJobsHandler,
Consumer<ActorControl> {
    private static final String JOBS_AVAILABLE_TOPIC = "jobsAvailable";
    private static final Logger LOG = Loggers.GATEWAY_LOGGER;
    private static final String ERROR_MSG_ACTIVATED_EXHAUSTED = "Expected to activate jobs of type '%s', but no jobs available and at least one broker returned 'RESOURCE_EXHAUSTED'. Please try again later.";
    private final RoundRobinActivateJobsHandler activateJobsHandler;
    private final BrokerClient brokerClient;
    private final Map<String, InFlightLongPollingActivateJobsRequestsState> jobTypeState = new ConcurrentHashMap<String, InFlightLongPollingActivateJobsRequestsState>();
    private final Duration longPollingTimeout;
    private final long probeTimeoutMillis;
    private final int failedAttemptThreshold;
    private final LongPollingMetrics metrics;
    private ActorControl actor;

    private LongPollingActivateJobsHandler(BrokerClient brokerClient, long longPollingTimeout, long probeTimeoutMillis, int failedAttemptThreshold) {
        this.brokerClient = brokerClient;
        this.activateJobsHandler = new RoundRobinActivateJobsHandler(brokerClient);
        this.longPollingTimeout = Duration.ofMillis(longPollingTimeout);
        this.probeTimeoutMillis = probeTimeoutMillis;
        this.failedAttemptThreshold = failedAttemptThreshold;
        this.metrics = new LongPollingMetrics();
    }

    @Override
    public void accept(ActorControl actor) {
        this.actor = actor;
        this.activateJobsHandler.accept(actor);
        this.onActorStarted();
    }

    protected void onActorStarted() {
        this.actor.run(() -> {
            this.brokerClient.subscribeJobAvailableNotification(JOBS_AVAILABLE_TOPIC, this::onNotification);
            this.actor.runAtFixedRate(Duration.ofMillis(this.probeTimeoutMillis), this::probe);
        });
    }

    @Override
    public void activateJobs(GatewayOuterClass.ActivateJobsRequest request, ServerStreamObserver<GatewayOuterClass.ActivateJobsResponse> responseObserver) {
        InflightActivateJobsRequest longPollingRequest = ActivateJobsHandler.toInflightActivateJobsRequest(request, responseObserver);
        this.activateJobs(longPollingRequest);
    }

    private void completeOrResubmitRequest(InflightActivateJobsRequest request, boolean activateImmediately) {
        if (request.isLongPollingDisabled()) {
            request.complete();
            return;
        }
        if (request.isTimedOut()) {
            return;
        }
        String type = request.getType();
        InFlightLongPollingActivateJobsRequestsState state = this.getJobTypeState(type);
        if (!request.hasScheduledTimer()) {
            this.addTimeOut(state, request);
        }
        if (activateImmediately) {
            this.activateJobs(request);
        } else {
            this.enqueueRequest(state, request);
        }
    }

    public void activateJobs(InflightActivateJobsRequest request) {
        this.actor.run(() -> {
            InFlightLongPollingActivateJobsRequestsState state = this.getJobTypeState(request.getType());
            if (state.shouldAttempt(this.failedAttemptThreshold)) {
                this.activateJobsUnchecked(state, request);
            } else {
                this.completeOrResubmitRequest(request, false);
            }
        });
    }

    private InFlightLongPollingActivateJobsRequestsState getJobTypeState(String jobType) {
        return this.jobTypeState.computeIfAbsent(jobType, type -> new InFlightLongPollingActivateJobsRequestsState((String)type, this.metrics));
    }

    private void activateJobsUnchecked(InFlightLongPollingActivateJobsRequestsState state, InflightActivateJobsRequest request) {
        BrokerClusterState topology = this.brokerClient.getTopologyManager().getTopology();
        if (topology != null) {
            state.addActiveRequest(request);
            int partitionsCount = topology.getPartitionsCount();
            this.activateJobsHandler.activateJobs(partitionsCount, request, error -> this.onError(state, request, (Throwable)error), (remainingAmount, containedResourceExhaustedResponse) -> this.onCompleted(state, request, (int)remainingAmount, (boolean)containedResourceExhaustedResponse));
        }
    }

    private void onNotification(String jobType) {
        LOG.trace("Received jobs available notification for type {}.", (Object)jobType);
        InFlightLongPollingActivateJobsRequestsState state = this.jobTypeState.get(jobType);
        if (state != null && state.shouldNotifyAndStartNotification()) {
            LOG.trace("Handle jobs available notification for type {}.", (Object)jobType);
            this.actor.run(() -> {
                this.resetFailedAttemptsAndHandlePendingRequests(jobType);
                state.completeNotification();
            });
        } else {
            LOG.trace("Ignore jobs available notification for type {}.", (Object)jobType);
        }
    }

    private void onCompleted(InFlightLongPollingActivateJobsRequestsState state, InflightActivateJobsRequest request, int remainingAmount, boolean containedResourceExhaustedResponse) {
        if (remainingAmount == request.getMaxJobsToActivate()) {
            if (containedResourceExhaustedResponse) {
                this.actor.submit(() -> {
                    state.removeActiveRequest(request);
                    String type = request.getType();
                    String errorMsg = String.format(ERROR_MSG_ACTIVATED_EXHAUSTED, type);
                    Status status = Status.newBuilder().setCode(8).setMessage(errorMsg).build();
                    request.onError((Throwable)StatusProto.toStatusException((Status)status));
                });
            } else {
                this.actor.submit(() -> {
                    state.incrementFailedAttempts(ActorClock.currentTimeMillis());
                    boolean shouldBeRepeated = state.shouldBeRepeated(request);
                    state.removeActiveRequest(request);
                    this.completeOrResubmitRequest(request, shouldBeRepeated);
                });
            }
        } else {
            this.actor.submit(() -> {
                request.complete();
                state.removeActiveRequest(request);
                this.resetFailedAttemptsAndHandlePendingRequests(request.getType());
            });
        }
    }

    private void onError(InFlightLongPollingActivateJobsRequestsState state, InflightActivateJobsRequest request, Throwable error) {
        this.actor.submit(() -> {
            request.onError(error);
            state.removeActiveRequest(request);
        });
    }

    private void resetFailedAttemptsAndHandlePendingRequests(String jobType) {
        InFlightLongPollingActivateJobsRequestsState state = this.getJobTypeState(jobType);
        state.resetFailedAttempts();
        Queue<InflightActivateJobsRequest> pendingRequests = state.getPendingRequests();
        if (!pendingRequests.isEmpty()) {
            pendingRequests.forEach(nextPendingRequest -> {
                LOG.trace("Unblocking ActivateJobsRequest {}", (Object)nextPendingRequest.getRequest());
                this.activateJobs((InflightActivateJobsRequest)nextPendingRequest);
            });
        } else if (!state.hasActiveRequests()) {
            this.jobTypeState.remove(jobType);
        }
    }

    private void enqueueRequest(InFlightLongPollingActivateJobsRequestsState state, InflightActivateJobsRequest request) {
        LOG.trace("Worker '{}' asked for '{}' jobs of type '{}', but none are available. This request will be kept open until a new job of this type is created or until timeout of '{}'.", new Object[]{request.getWorker(), request.getMaxJobsToActivate(), request.getType(), request.getLongPollingTimeout(this.longPollingTimeout)});
        state.enqueueRequest(request);
    }

    private void addTimeOut(InFlightLongPollingActivateJobsRequestsState state, InflightActivateJobsRequest request) {
        Duration requestTimeout = request.getLongPollingTimeout(this.longPollingTimeout);
        ScheduledTimer timeout = this.actor.runDelayed(requestTimeout, () -> {
            request.timeout();
            state.removeRequest(request);
        });
        request.setScheduledTimer(timeout);
    }

    private void probe() {
        long now = ActorClock.currentTimeMillis();
        this.jobTypeState.forEach((type, state) -> {
            if (state.getLastUpdatedTime() < now - this.probeTimeoutMillis) {
                InflightActivateJobsRequest probeRequest = state.getNextPendingRequest();
                if (probeRequest != null) {
                    this.activateJobsUnchecked((InFlightLongPollingActivateJobsRequestsState)state, probeRequest);
                } else if (state.getFailedAttempts() >= this.failedAttemptThreshold) {
                    state.setFailedAttempts(this.failedAttemptThreshold - 1);
                }
            }
        });
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private static final long DEFAULT_LONG_POLLING_TIMEOUT = 10000L;
        private static final long DEFAULT_PROBE_TIMEOUT = 10000L;
        private static final int EMPTY_RESPONSE_THRESHOLD = 3;
        private BrokerClient brokerClient;
        private long longPollingTimeout = 10000L;
        private long probeTimeoutMillis = 10000L;
        private int minEmptyResponses = 3;

        public Builder setBrokerClient(BrokerClient brokerClient) {
            this.brokerClient = brokerClient;
            return this;
        }

        public Builder setLongPollingTimeout(long longPollingTimeout) {
            this.longPollingTimeout = longPollingTimeout;
            return this;
        }

        public Builder setProbeTimeoutMillis(long probeTimeoutMillis) {
            this.probeTimeoutMillis = probeTimeoutMillis;
            return this;
        }

        public Builder setMinEmptyResponses(int minEmptyResponses) {
            this.minEmptyResponses = minEmptyResponses;
            return this;
        }

        public LongPollingActivateJobsHandler build() {
            Objects.requireNonNull(this.brokerClient, "brokerClient");
            return new LongPollingActivateJobsHandler(this.brokerClient, this.longPollingTimeout, this.probeTimeoutMillis, this.minEmptyResponses);
        }
    }
}

