/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import io.atomix.cluster.messaging.impl.AbstractClientConnection;
import io.atomix.cluster.messaging.impl.ProtocolRequest;
import io.netty.channel.Channel;
import java.util.concurrent.CompletableFuture;

final class RemoteClientConnection
extends AbstractClientConnection {
    private final Channel channel;

    RemoteClientConnection(Channel channel) {
        this.channel = channel;
    }

    @Override
    public CompletableFuture<Void> sendAsync(ProtocolRequest message) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.channel.writeAndFlush((Object)message).addListener(channelFuture -> {
            if (!channelFuture.isSuccess()) {
                future.completeExceptionally(channelFuture.cause());
            } else {
                future.complete(null);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<byte[]> sendAndReceive(ProtocolRequest message) {
        CompletableFuture<byte[]> responseFuture = this.awaitResponseForRequestWithId(message.id());
        this.channel.writeAndFlush((Object)message).addListener(channelFuture -> {
            if (!channelFuture.isSuccess()) {
                responseFuture.completeExceptionally(channelFuture.cause());
            }
        });
        return responseFuture;
    }

    public String toString() {
        return "RemoteClientConnection{channel=" + this.channel + "}";
    }
}

