/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.gateway.management;

import io.camunda.zeebe.gateway.admin.BrokerAdminRequest;
import io.camunda.zeebe.gateway.impl.SpringGatewayBridge;
import io.camunda.zeebe.gateway.impl.broker.BrokerClient;
import io.camunda.zeebe.gateway.impl.broker.request.BrokerRequest;
import io.camunda.zeebe.shared.management.RebalancingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class GatewayRebalancingService
implements RebalancingService {
    private final SpringGatewayBridge bridge;

    @Autowired
    public GatewayRebalancingService(SpringGatewayBridge bridge) {
        this.bridge = bridge;
    }

    @Override
    public void rebalanceCluster() {
        BrokerClient client = (BrokerClient)this.bridge.getBrokerClient().orElseThrow(() -> new IllegalStateException("No broker client available"));
        client.getTopologyManager().getTopology().getPartitions().forEach(partition -> {
            BrokerAdminRequest request = new BrokerAdminRequest();
            request.setPartitionId(partition.intValue());
            request.stepDownIfNotPrimary();
            client.sendRequest((BrokerRequest)request);
        });
    }
}

