/*
 * Decompiled with CFR 0.152.
 */
package me.dinowernli.grpc.prometheus;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.MethodDescriptor;
import java.time.Clock;
import me.dinowernli.grpc.prometheus.ClientMetrics;
import me.dinowernli.grpc.prometheus.Configuration;
import me.dinowernli.grpc.prometheus.GrpcMethod;
import me.dinowernli.grpc.prometheus.MonitoringClientCall;

public class MonitoringClientInterceptor
implements ClientInterceptor {
    private final Clock clock;
    private final Configuration configuration;
    private final ClientMetrics.Factory clientMetricsFactory;

    public static MonitoringClientInterceptor create(Configuration configuration) {
        return new MonitoringClientInterceptor(Clock.systemDefaultZone(), configuration, new ClientMetrics.Factory(configuration));
    }

    private MonitoringClientInterceptor(Clock clock, Configuration configuration, ClientMetrics.Factory clientMetricsFactory) {
        this.clock = clock;
        this.configuration = configuration;
        this.clientMetricsFactory = clientMetricsFactory;
    }

    public <R, S> ClientCall<R, S> interceptCall(MethodDescriptor<R, S> methodDescriptor, CallOptions callOptions, Channel channel) {
        GrpcMethod grpcMethod = GrpcMethod.of(methodDescriptor);
        ClientMetrics metrics = this.clientMetricsFactory.createMetricsForMethod(grpcMethod);
        return new MonitoringClientCall(channel.newCall(methodDescriptor, callOptions), metrics, grpcMethod, this.configuration, this.clock);
    }
}

