/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.container;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContainerProcessor;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableLoopCharacteristics;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableMultiInstanceBody;
import io.camunda.zeebe.engine.state.instance.EventTrigger;
import io.camunda.zeebe.msgpack.spec.MsgPackHelper;
import io.camunda.zeebe.msgpack.spec.MsgPackReader;
import io.camunda.zeebe.msgpack.spec.MsgPackWriter;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.List;
import java.util.Optional;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class MultiInstanceBodyProcessor
implements BpmnElementContainerProcessor<ExecutableMultiInstanceBody> {
    private static final DirectBuffer NIL_VALUE = new UnsafeBuffer(MsgPackHelper.NIL);
    private static final DirectBuffer LOOP_COUNTER_VARIABLE = BufferUtil.wrapString((String)"loopCounter");
    private final MutableDirectBuffer loopCounterVariableBuffer = new UnsafeBuffer(new byte[9]);
    private final DirectBuffer loopCounterVariableView = new UnsafeBuffer(0L, 0);
    private final MsgPackReader variableReader = new MsgPackReader();
    private final MsgPackWriter variableWriter = new MsgPackWriter();
    private final ExpandableArrayBuffer variableBuffer = new ExpandableArrayBuffer();
    private final DirectBuffer resultBuffer = new UnsafeBuffer(0L, 0);
    private final ExpressionProcessor expressionBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
    private final BpmnStateBehavior stateBehavior;
    private final BpmnIncidentBehavior incidentBehavior;

    public MultiInstanceBodyProcessor(BpmnBehaviors bpmnBehaviors) {
        this.stateTransitionBehavior = bpmnBehaviors.stateTransitionBehavior();
        this.eventSubscriptionBehavior = bpmnBehaviors.eventSubscriptionBehavior();
        this.stateBehavior = bpmnBehaviors.stateBehavior();
        this.expressionBehavior = bpmnBehaviors.expressionBehavior();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
    }

    @Override
    public Class<ExecutableMultiInstanceBody> getType() {
        return ExecutableMultiInstanceBody.class;
    }

    @Override
    public void onActivate(ExecutableMultiInstanceBody element, BpmnElementContext context) {
        this.readInputCollectionVariable(element, context).flatMap(inputCollection -> this.eventSubscriptionBehavior.subscribeToEvents(element, context).map(ok -> inputCollection)).ifRightOrLeft(inputCollection -> this.activate(element, context, (List<DirectBuffer>)inputCollection), failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    @Override
    public void onComplete(ExecutableMultiInstanceBody element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
        element.getLoopCharacteristics().getOutputCollection().ifPresent(variableName -> this.stateBehavior.propagateVariable(context, (DirectBuffer)variableName));
        this.stateTransitionBehavior.transitionToCompleted(element, context).ifRightOrLeft(completed -> this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed), failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    @Override
    public void onTerminate(ExecutableMultiInstanceBody element, BpmnElementContext context) {
        this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
        boolean noActiveChildInstances = this.stateTransitionBehavior.terminateChildInstances(context);
        if (noActiveChildInstances) {
            this.terminate(element, context);
        }
    }

    @Override
    public Either<Failure, ?> onChildActivating(ExecutableMultiInstanceBody multiInstanceBody, BpmnElementContext flowScopeContext, BpmnElementContext childContext) {
        int loopCounter = this.stateBehavior.getElementInstance(childContext).getMultiInstanceLoopCounter();
        return this.readInputCollectionVariable(multiInstanceBody, childContext).flatMap(collection -> {
            int index = loopCounter - 1;
            if (index < collection.size()) {
                DirectBuffer item = (DirectBuffer)collection.get(index);
                return Either.right((Object)item);
            }
            String incidentMessage = String.format("Expected to read item at index %d of the multiInstanceBody input collection but it contains only %d elements. The input collection might be modified while iterating over it.", index, collection.size());
            Failure failure = new Failure(incidentMessage, ErrorType.EXTRACT_VALUE_ERROR);
            return Either.left((Object)failure);
        }).map(inputElement -> {
            this.setLoopVariables(multiInstanceBody, childContext, loopCounter, (DirectBuffer)inputElement);
            return null;
        });
    }

    @Override
    public Either<Failure, ?> beforeExecutionPathCompleted(ExecutableMultiInstanceBody element, BpmnElementContext flowScopeContext, BpmnElementContext childContext) {
        Either<Failure, Void> updatedOrFailure = this.updateOutputCollection(element, childContext, flowScopeContext);
        if (updatedOrFailure.isLeft()) {
            return updatedOrFailure;
        }
        Either<Failure, Boolean> satisfiesCompletionConditionOrFailure = this.satisfiesCompletionCondition(element, childContext);
        if (satisfiesCompletionConditionOrFailure.isLeft()) {
            return satisfiesCompletionConditionOrFailure;
        }
        if (!element.getLoopCharacteristics().isSequential()) {
            return Either.right((Object)((Boolean)satisfiesCompletionConditionOrFailure.get()));
        }
        return this.readInputCollectionVariable(element, flowScopeContext).map(ok -> (Boolean)satisfiesCompletionConditionOrFailure.get());
    }

    @Override
    public void afterExecutionPathCompleted(ExecutableMultiInstanceBody element, BpmnElementContext flowScopeContext, BpmnElementContext childContext, Boolean satisfiesCompletionCondition) {
        boolean childInstanceCreated = false;
        ExecutableLoopCharacteristics loopCharacteristics = element.getLoopCharacteristics();
        if (satisfiesCompletionCondition.booleanValue()) {
            boolean hasNoActiveChildren = this.stateTransitionBehavior.terminateChildInstances(flowScopeContext);
            if (hasNoActiveChildren || loopCharacteristics.isSequential()) {
                this.stateTransitionBehavior.completeElement(flowScopeContext);
            }
            return;
        }
        if (loopCharacteristics.isSequential()) {
            Either<Failure, List<DirectBuffer>> inputCollectionOrFailure = this.readInputCollectionVariable(element, flowScopeContext);
            if (inputCollectionOrFailure.isLeft()) {
                this.incidentBehavior.createIncident((Failure)inputCollectionOrFailure.getLeft(), childContext);
                return;
            }
            List inputCollection = (List)inputCollectionOrFailure.get();
            int loopCounter = this.stateBehavior.getElementInstance(flowScopeContext).getMultiInstanceLoopCounter();
            if (loopCounter < inputCollection.size()) {
                this.createInnerInstance(element, flowScopeContext);
                childInstanceCreated = true;
            }
        }
        if (!childInstanceCreated && this.stateBehavior.canBeCompleted(childContext)) {
            this.stateTransitionBehavior.completeElement(flowScopeContext);
        }
    }

    @Override
    public void onChildTerminated(ExecutableMultiInstanceBody element, BpmnElementContext flowScopeContext, BpmnElementContext childContext) {
        if (flowScopeContext.getIntent() == ProcessInstanceIntent.ELEMENT_TERMINATING) {
            if (this.stateBehavior.canBeTerminated(childContext)) {
                this.terminate(element, flowScopeContext);
            }
        } else if (this.stateBehavior.canBeCompleted(childContext)) {
            this.stateTransitionBehavior.completeElement(flowScopeContext);
        }
    }

    private void activate(ExecutableMultiInstanceBody element, BpmnElementContext context, List<DirectBuffer> inputCollection) {
        BpmnElementContext activated = this.stateTransitionBehavior.transitionToActivated(context);
        ExecutableLoopCharacteristics loopCharacteristics = element.getLoopCharacteristics();
        loopCharacteristics.getOutputCollection().ifPresent(variableName -> this.initializeOutputCollection(activated, (DirectBuffer)variableName, inputCollection.size()));
        if (inputCollection.isEmpty()) {
            this.stateTransitionBehavior.completeElement(activated);
            return;
        }
        if (loopCharacteristics.isSequential()) {
            this.createInnerInstance(element, activated);
        } else {
            inputCollection.forEach(item -> this.createInnerInstance(element, activated));
        }
    }

    private void terminate(ExecutableMultiInstanceBody element, BpmnElementContext flowScopeContext) {
        this.incidentBehavior.resolveIncidents(flowScopeContext);
        this.eventSubscriptionBehavior.findEventTrigger(flowScopeContext).ifPresentOrElse(eventTrigger -> {
            BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(flowScopeContext);
            this.eventSubscriptionBehavior.activateTriggeredEvent(flowScopeContext.getElementInstanceKey(), terminated.getFlowScopeKey(), (EventTrigger)((Object)eventTrigger), terminated);
            this.stateTransitionBehavior.onElementTerminated(element, terminated);
        }, () -> {
            BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(flowScopeContext);
            this.stateTransitionBehavior.onElementTerminated(element, terminated);
        });
    }

    private void setLoopVariables(ExecutableMultiInstanceBody multiInstanceBody, BpmnElementContext childContext, int loopCounter, DirectBuffer inputElement) {
        ExecutableLoopCharacteristics loopCharacteristics = multiInstanceBody.getLoopCharacteristics();
        loopCharacteristics.getInputElement().ifPresent(variableName -> this.stateBehavior.setLocalVariable(childContext, (DirectBuffer)variableName, inputElement));
        loopCharacteristics.getOutputElement().flatMap(Expression::getVariableName).map(BufferUtil::wrapString).ifPresent(variableName -> this.stateBehavior.setLocalVariable(childContext, (DirectBuffer)variableName, NIL_VALUE));
        this.stateBehavior.setLocalVariable(childContext, LOOP_COUNTER_VARIABLE, this.wrapLoopCounter(loopCounter));
    }

    private Either<Failure, List<DirectBuffer>> readInputCollectionVariable(ExecutableMultiInstanceBody element, BpmnElementContext context) {
        Expression inputCollection = element.getLoopCharacteristics().getInputCollection();
        return this.expressionBehavior.evaluateArrayExpression(inputCollection, context.getElementInstanceKey());
    }

    private void createInnerInstance(ExecutableMultiInstanceBody multiInstanceBody, BpmnElementContext context) {
        this.stateTransitionBehavior.activateChildInstanceWithKey(context, multiInstanceBody.getInnerActivity());
    }

    private DirectBuffer wrapLoopCounter(int loopCounter) {
        this.variableWriter.wrap(this.loopCounterVariableBuffer, 0);
        this.variableWriter.writeInteger((long)loopCounter);
        int length = this.variableWriter.getOffset();
        this.loopCounterVariableView.wrap((DirectBuffer)this.loopCounterVariableBuffer, 0, length);
        return this.loopCounterVariableView;
    }

    private void initializeOutputCollection(BpmnElementContext context, DirectBuffer variableName, int size) {
        this.variableWriter.wrap((MutableDirectBuffer)this.variableBuffer, 0);
        this.variableWriter.writeArrayHeader(size);
        for (int i = 0; i < size; ++i) {
            this.variableWriter.writeNil();
        }
        int length = this.variableWriter.getOffset();
        this.stateBehavior.setLocalVariable(context, variableName, (DirectBuffer)this.variableBuffer, 0, length);
    }

    private Either<Failure, Void> updateOutputCollection(ExecutableMultiInstanceBody element, BpmnElementContext childContext, BpmnElementContext flowScopeContext) {
        return element.getLoopCharacteristics().getOutputCollection().map(variableName -> this.updateOutputCollection(element, childContext, flowScopeContext, (DirectBuffer)variableName)).orElse(Either.right(null));
    }

    private Either<Failure, Void> updateOutputCollection(ExecutableMultiInstanceBody element, BpmnElementContext childContext, BpmnElementContext flowScopeContext, DirectBuffer variableName) {
        int loopCounter = this.stateBehavior.getElementInstance(childContext).getMultiInstanceLoopCounter();
        return this.readOutputElementVariable(element, childContext).map(elementVariable -> {
            DirectBuffer currentCollection = this.stateBehavior.getLocalVariable(flowScopeContext, variableName);
            DirectBuffer updatedCollection = this.insertAt(currentCollection, loopCounter, (DirectBuffer)elementVariable);
            this.stateBehavior.setLocalVariable(flowScopeContext, variableName, updatedCollection);
            return null;
        });
    }

    private Either<Failure, DirectBuffer> readOutputElementVariable(ExecutableMultiInstanceBody element, BpmnElementContext context) {
        Expression expression = element.getLoopCharacteristics().getOutputElement().orElseThrow();
        return this.expressionBehavior.evaluateAnyExpression(expression, context.getElementInstanceKey());
    }

    private DirectBuffer insertAt(DirectBuffer array, int index, DirectBuffer element) {
        this.variableReader.wrap(array, 0, array.capacity());
        this.variableReader.readArrayHeader();
        this.variableReader.skipValues((long)index - 1L);
        int offsetBefore = this.variableReader.getOffset();
        this.variableReader.skipValue();
        int offsetAfter = this.variableReader.getOffset();
        this.variableWriter.wrap((MutableDirectBuffer)this.variableBuffer, 0);
        this.variableWriter.writeRaw(array, 0, offsetBefore);
        this.variableWriter.writeRaw(element);
        this.variableWriter.writeRaw(array, offsetAfter, array.capacity() - offsetAfter);
        int length = this.variableWriter.getOffset();
        this.resultBuffer.wrap((DirectBuffer)this.variableBuffer, 0, length);
        return this.resultBuffer;
    }

    private Either<Failure, Boolean> satisfiesCompletionCondition(ExecutableMultiInstanceBody element, BpmnElementContext context) {
        Optional<Expression> completionCondition = element.getLoopCharacteristics().getCompletionCondition();
        if (completionCondition.isPresent()) {
            return this.expressionBehavior.evaluateBooleanExpression(completionCondition.get(), context.getElementInstanceKey());
        }
        return Either.right((Object)false);
    }
}

