/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.task;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableJobWorkerTask;
import io.camunda.zeebe.engine.state.instance.EventTrigger;

public final class JobWorkerTaskProcessor
implements BpmnElementProcessor<ExecutableJobWorkerTask> {
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnVariableMappingBehavior variableMappingBehavior;
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
    private final BpmnJobBehavior jobBehavior;

    public JobWorkerTaskProcessor(BpmnBehaviors behaviors) {
        this.eventSubscriptionBehavior = behaviors.eventSubscriptionBehavior();
        this.incidentBehavior = behaviors.incidentBehavior();
        this.stateTransitionBehavior = behaviors.stateTransitionBehavior();
        this.variableMappingBehavior = behaviors.variableMappingBehavior();
        this.jobBehavior = behaviors.jobBehavior();
    }

    @Override
    public Class<ExecutableJobWorkerTask> getType() {
        return ExecutableJobWorkerTask.class;
    }

    @Override
    public void onActivate(ExecutableJobWorkerTask element, BpmnElementContext context) {
        this.variableMappingBehavior.applyInputMappings(context, element).flatMap(ok -> this.eventSubscriptionBehavior.subscribeToEvents(element, context)).flatMap(ok -> this.jobBehavior.createNewJob(context, element)).ifRightOrLeft(ok -> this.stateTransitionBehavior.transitionToActivated(context), failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    @Override
    public void onComplete(ExecutableJobWorkerTask element, BpmnElementContext context) {
        this.variableMappingBehavior.applyOutputMappings(context, element).flatMap(ok -> {
            this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
            return this.stateTransitionBehavior.transitionToCompleted(element, context);
        }).ifRightOrLeft(completed -> this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed), failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    @Override
    public void onTerminate(ExecutableJobWorkerTask element, BpmnElementContext context) {
        this.jobBehavior.cancelJob(context);
        this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
        this.incidentBehavior.resolveIncidents(context);
        this.eventSubscriptionBehavior.findEventTrigger(context).ifPresentOrElse(eventTrigger -> {
            BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context);
            this.eventSubscriptionBehavior.activateTriggeredEvent(context.getElementInstanceKey(), terminated.getFlowScopeKey(), (EventTrigger)((Object)eventTrigger), terminated);
        }, () -> {
            BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context);
            this.stateTransitionBehavior.onElementTerminated(element, terminated);
        });
    }
}

