/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.engine.Loggers;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableJobWorkerElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.element.JobWorkerProperties;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.camunda.zeebe.model.bpmn.instance.FlowElement;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeHeader;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskDefinition;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskHeaders;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public final class JobWorkerElementTransformer<T extends FlowElement>
implements ModelElementTransformer<T> {
    private static final Logger LOG = Loggers.STREAM_PROCESSING;
    private final Class<T> type;

    public JobWorkerElementTransformer(Class<T> type) {
        this.type = type;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public void transform(T element, TransformContext context) {
        ExecutableProcess process = context.getCurrentProcess();
        ExecutableJobWorkerElement jobWorkerElement = process.getElementById(element.getId(), ExecutableJobWorkerElement.class);
        JobWorkerProperties jobWorkerProperties = new JobWorkerProperties();
        jobWorkerElement.setJobWorkerProperties(jobWorkerProperties);
        this.transformTaskDefinition(element, jobWorkerProperties, context);
        this.transformTaskHeaders(element, jobWorkerProperties);
    }

    private void transformTaskDefinition(T element, JobWorkerProperties jobWorkerProperties, TransformContext context) {
        ZeebeTaskDefinition taskDefinition = (ZeebeTaskDefinition)element.getSingleExtensionElement(ZeebeTaskDefinition.class);
        ExpressionLanguage expressionLanguage = context.getExpressionLanguage();
        Expression jobTypeExpression = expressionLanguage.parseExpression(taskDefinition.getType());
        jobWorkerProperties.setType(jobTypeExpression);
        Expression retriesExpression = expressionLanguage.parseExpression(taskDefinition.getRetries());
        jobWorkerProperties.setRetries(retriesExpression);
    }

    private void transformTaskHeaders(T element, JobWorkerProperties jobWorkerProperties) {
        ZeebeTaskHeaders taskHeaders = (ZeebeTaskHeaders)element.getSingleExtensionElement(ZeebeTaskHeaders.class);
        if (taskHeaders != null) {
            Map<String, String> validHeaders = taskHeaders.getHeaders().stream().filter(this::isValidHeader).collect(Collectors.toMap(ZeebeHeader::getKey, ZeebeHeader::getValue));
            if (validHeaders.size() < taskHeaders.getHeaders().size()) {
                LOG.warn("Ignoring invalid headers for task '{}'. Must have non-empty key and value.", (Object)element.getName());
            }
            if (!validHeaders.isEmpty()) {
                jobWorkerProperties.setTaskHeaders(validHeaders);
            }
        }
    }

    private boolean isValidHeader(ZeebeHeader header) {
        return header != null && header.getValue() != null && !header.getValue().isEmpty() && header.getKey() != null && !header.getKey().isEmpty();
    }
}

