/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.immutable.VariableState;
import io.camunda.zeebe.msgpack.value.DocumentValue;
import io.camunda.zeebe.msgpack.value.LongValue;
import io.camunda.zeebe.msgpack.value.ValueArray;
import io.camunda.zeebe.protocol.impl.record.value.job.JobBatchRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Collection;
import java.util.function.Predicate;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.MutableInteger;
import org.agrona.collections.MutableReference;
import org.agrona.collections.ObjectHashSet;

final class JobBatchCollector {
    private final ObjectHashSet<DirectBuffer> variableNames = new ObjectHashSet();
    private final JobState jobState;
    private final VariableState variableState;
    private final Predicate<Integer> canWriteEventOfLength;

    JobBatchCollector(JobState jobState, VariableState variableState, Predicate<Integer> canWriteEventOfLength) {
        this.jobState = jobState;
        this.variableState = variableState;
        this.canWriteEventOfLength = canWriteEventOfLength;
    }

    Either<TooLargeJob, Integer> collectJobs(TypedRecord<JobBatchRecord> record) {
        JobBatchRecord value = record.getValue();
        ValueArray jobIterator = value.jobs();
        ValueArray jobKeyIterator = value.jobKeys();
        Collection<DirectBuffer> requestedVariables = this.collectVariableNames(value);
        int maxActivatedCount = value.getMaxJobsToActivate();
        MutableInteger activatedCount = new MutableInteger(0);
        ExpandableArrayBuffer jobCopyBuffer = new ExpandableArrayBuffer();
        MutableReference unwritableJob = new MutableReference();
        this.jobState.forEachActivatableJobs(value.getTypeBuffer(), (key, jobRecord) -> {
            long deadline = record.getTimestamp() + value.getTimeout();
            jobRecord.setDeadline(deadline).setWorker(value.getWorkerBuffer());
            this.setJobVariables(requestedVariables, (JobRecord)jobRecord, jobRecord.getElementInstanceKey());
            int jobRecordLength = jobRecord.getLength();
            int expectedEventLength = record.getLength() + jobRecordLength + 8 + 1;
            if (activatedCount.value > maxActivatedCount || !this.canWriteEventOfLength.test(expectedEventLength)) {
                if (activatedCount.value == 0) {
                    unwritableJob.set((Object)new TooLargeJob((long)key, (JobRecord)jobRecord));
                }
                value.setTruncated(true);
                return false;
            }
            this.appendJobToBatch((ValueArray<JobRecord>)jobIterator, (ValueArray<LongValue>)jobKeyIterator, jobCopyBuffer, (Long)key, (JobRecord)jobRecord);
            activatedCount.increment();
            return activatedCount.value < maxActivatedCount;
        });
        if (unwritableJob.ref != null) {
            return Either.left((Object)((TooLargeJob)unwritableJob.ref));
        }
        return Either.right((Object)activatedCount.value);
    }

    private void setJobVariables(Collection<DirectBuffer> requestedVariables, JobRecord jobRecord, long elementInstanceKey) {
        if (elementInstanceKey >= 0L) {
            DirectBuffer variables = this.collectVariables(requestedVariables, elementInstanceKey);
            jobRecord.setVariables(variables);
        } else {
            jobRecord.setVariables(DocumentValue.EMPTY_DOCUMENT);
        }
    }

    private void appendJobToBatch(ValueArray<JobRecord> jobIterator, ValueArray<LongValue> jobKeyIterator, ExpandableArrayBuffer jobCopyBuffer, Long key, JobRecord jobRecord) {
        ((LongValue)jobKeyIterator.add()).setValue(key.longValue());
        JobRecord arrayValueJob = (JobRecord)jobIterator.add();
        jobRecord.write((MutableDirectBuffer)jobCopyBuffer, 0);
        arrayValueJob.wrap((DirectBuffer)jobCopyBuffer, 0, jobRecord.getLength());
    }

    private Collection<DirectBuffer> collectVariableNames(JobBatchRecord batchRecord) {
        ValueArray requestedVariables = batchRecord.variables();
        this.variableNames.clear();
        requestedVariables.forEach(variable -> this.variableNames.add((Object)BufferUtil.cloneBuffer((DirectBuffer)variable.getValue())));
        return this.variableNames;
    }

    private DirectBuffer collectVariables(Collection<DirectBuffer> variableNames, long elementInstanceKey) {
        DirectBuffer variables = variableNames.isEmpty() ? this.variableState.getVariablesAsDocument(elementInstanceKey) : this.variableState.getVariablesAsDocument(elementInstanceKey, variableNames);
        return variables;
    }

    static final class TooLargeJob {
        private final long key;
        private final JobRecord job;

        private TooLargeJob(long key, JobRecord job) {
            this.key = key;
            this.job = job;
        }

        long key() {
            return this.key;
        }

        JobRecord record() {
            return this.job;
        }
    }
}

