/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.metrics.JobMetrics;
import io.camunda.zeebe.engine.processing.job.DefaultJobCommandPreconditionGuard;
import io.camunda.zeebe.engine.processing.job.JobBackoffChecker;
import io.camunda.zeebe.engine.processing.streamprocessor.CommandProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.camunda.zeebe.engine.processing.streamprocessor.sideeffect.SideEffectProducer;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.state.KeyGenerator;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.immutable.ZeebeState;
import io.camunda.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;

public final class JobFailProcessor
implements CommandProcessor<JobRecord> {
    private static final DirectBuffer DEFAULT_ERROR_MESSAGE = BufferUtil.wrapString((String)"No more retries left.");
    private final IncidentRecord incidentEvent = new IncidentRecord();
    private final JobState jobState;
    private final DefaultJobCommandPreconditionGuard defaultProcessor;
    private final KeyGenerator keyGenerator;
    private final JobMetrics jobMetrics;
    private final JobBackoffChecker jobBackoffChecker;

    public JobFailProcessor(ZeebeState state, KeyGenerator keyGenerator, JobMetrics jobMetrics, JobBackoffChecker jobBackoffChecker) {
        this.jobState = state.getJobState();
        this.keyGenerator = keyGenerator;
        this.jobBackoffChecker = jobBackoffChecker;
        this.defaultProcessor = new DefaultJobCommandPreconditionGuard("fail", this.jobState, this::acceptCommand);
        this.jobMetrics = jobMetrics;
    }

    @Override
    public boolean onCommand(TypedRecord<JobRecord> command, CommandProcessor.CommandControl<JobRecord> commandControl, Consumer<SideEffectProducer> sideEffect) {
        return this.defaultProcessor.onCommand(command, commandControl, sideEffect);
    }

    @Override
    public void afterAccept(TypedCommandWriter commandWriter, StateWriter stateWriter, long key, Intent intent, JobRecord value) {
        if (value.getRetries() <= 0) {
            DirectBuffer jobErrorMessage = value.getErrorMessageBuffer();
            DirectBuffer incidentErrorMessage = DEFAULT_ERROR_MESSAGE;
            if (jobErrorMessage.capacity() > 0) {
                incidentErrorMessage = jobErrorMessage;
            }
            this.incidentEvent.reset();
            this.incidentEvent.setErrorType(ErrorType.JOB_NO_RETRIES).setErrorMessage(incidentErrorMessage).setBpmnProcessId(value.getBpmnProcessIdBuffer()).setProcessDefinitionKey(value.getProcessDefinitionKey()).setProcessInstanceKey(value.getProcessInstanceKey()).setElementId(value.getElementIdBuffer()).setElementInstanceKey(value.getElementInstanceKey()).setJobKey(key).setVariableScopeKey(value.getElementInstanceKey());
            stateWriter.appendFollowUpEvent(this.keyGenerator.nextKey(), (Intent)IncidentIntent.CREATED, (RecordValue)this.incidentEvent);
        }
    }

    private void acceptCommand(TypedRecord<JobRecord> command, CommandProcessor.CommandControl<JobRecord> commandControl, Consumer<SideEffectProducer> sideEffect) {
        long key = command.getKey();
        JobRecord failedJob = this.jobState.getJob(key);
        int retries = command.getValue().getRetries();
        long retryBackOff = command.getValue().getRetryBackoff();
        failedJob.setRetries(retries);
        failedJob.setErrorMessage(command.getValue().getErrorMessageBuffer());
        failedJob.setRetryBackoff(retryBackOff);
        if (retries > 0 && retryBackOff > 0L) {
            long receivedTime = command.getTimestamp();
            failedJob.setRecurringTime(receivedTime + retryBackOff);
            sideEffect.accept(() -> {
                this.jobBackoffChecker.scheduleBackOff(retryBackOff + receivedTime);
                return true;
            });
        }
        commandControl.accept((Intent)JobIntent.FAILED, failedJob);
        this.jobMetrics.jobFailed(failedJob.getType());
    }
}

