/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.processing.streamprocessor.CommandProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecord;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.immutable.ZeebeState;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;

public class JobRecurProcessor
implements CommandProcessor<JobRecord> {
    private static final String NOT_FAILED_JOB_MESSAGE = "Expected to back off failed job with key '%d', but %s";
    private final JobState jobState;

    public JobRecurProcessor(ZeebeState zeebeState) {
        this.jobState = zeebeState.getJobState();
    }

    @Override
    public boolean onCommand(TypedRecord<JobRecord> command, CommandProcessor.CommandControl<JobRecord> commandControl) {
        long jobKey = command.getKey();
        JobState.State state = this.jobState.getState(jobKey);
        if (state == JobState.State.FAILED) {
            commandControl.accept((Intent)JobIntent.RECURRED_AFTER_BACKOFF, command.getValue());
        } else {
            String textState;
            switch (state) {
                case ACTIVATABLE: {
                    textState = "it is already activable";
                    break;
                }
                case ACTIVATED: {
                    textState = "it is already activated";
                    break;
                }
                case ERROR_THROWN: {
                    textState = "it is in error state";
                    break;
                }
                default: {
                    textState = "no such job was found";
                }
            }
            commandControl.reject(RejectionType.NOT_FOUND, String.format(NOT_FAILED_JOB_MESSAGE, jobKey, textState));
        }
        return true;
    }
}

