/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.scheduled;

import io.camunda.zeebe.engine.processing.streamprocessor.ReadonlyProcessingContext;
import io.camunda.zeebe.engine.processing.streamprocessor.StreamProcessorLifecycleAware;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedStreamWriter;
import io.camunda.zeebe.util.sched.ActorControl;
import io.camunda.zeebe.util.sched.ScheduledTimer;
import io.camunda.zeebe.util.sched.clock.ActorClock;
import java.time.Duration;
import java.util.function.Function;

public final class DueDateChecker
implements StreamProcessorLifecycleAware {
    private ActorControl actor;
    private TypedStreamWriter streamWriter;
    private ScheduledTimer scheduledTimer;
    private long nextDueDate = -1L;
    private final long timerResolution;
    private final Function<TypedCommandWriter, Long> nextDueDateSupplier;

    public DueDateChecker(long timerResolution, Function<TypedCommandWriter, Long> nextDueDateFunction) {
        this.timerResolution = timerResolution;
        this.nextDueDateSupplier = nextDueDateFunction;
    }

    public void schedule(long dueDate) {
        Duration duration = Duration.ofMillis(dueDate - ActorClock.currentTimeMillis());
        if (this.scheduledTimer == null) {
            this.scheduledTimer = this.actor.runDelayed(duration, this::triggerEntities);
            this.nextDueDate = dueDate;
        } else if (this.nextDueDate - dueDate > this.timerResolution) {
            this.scheduledTimer.cancel();
            this.scheduledTimer = this.actor.runDelayed(duration, this::triggerEntities);
            this.nextDueDate = dueDate;
        }
    }

    private void triggerEntities() {
        this.nextDueDate = this.nextDueDateSupplier.apply(this.streamWriter);
        if (this.nextDueDate > 0L) {
            Duration duration = Duration.ofMillis(this.nextDueDate - ActorClock.currentTimeMillis());
            this.scheduledTimer = this.actor.runDelayed(duration, this::triggerEntities);
        } else {
            this.scheduledTimer = null;
        }
    }

    @Override
    public void onRecovered(ReadonlyProcessingContext processingContext) {
        this.actor = processingContext.getActor();
        this.streamWriter = processingContext.getLogStreamWriter();
        this.triggerEntities();
    }

    @Override
    public void onPaused() {
        if (this.scheduledTimer != null) {
            this.scheduledTimer.cancel();
            this.scheduledTimer = null;
        }
    }

    @Override
    public void onResumed() {
        if (this.scheduledTimer == null) {
            this.triggerEntities();
        }
    }
}

