/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.timer;

import io.camunda.zeebe.engine.processing.scheduled.DueDateChecker;
import io.camunda.zeebe.engine.processing.streamprocessor.ReadonlyProcessingContext;
import io.camunda.zeebe.engine.processing.streamprocessor.StreamProcessorLifecycleAware;
import io.camunda.zeebe.engine.state.immutable.TimerInstanceState;
import io.camunda.zeebe.protocol.impl.record.value.timer.TimerRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.util.sched.clock.ActorClock;
import java.time.Duration;

public class DueDateTimerChecker
implements StreamProcessorLifecycleAware {
    private static final long TIMER_RESOLUTION = Duration.ofMillis(100L).toMillis();
    private final DueDateChecker dueDateChecker;
    private final TimerRecord timerRecord = new TimerRecord();

    public DueDateTimerChecker(TimerInstanceState timerInstanceState) {
        this.dueDateChecker = new DueDateChecker(TIMER_RESOLUTION, typedCommandWriter -> timerInstanceState.findTimersWithDueDateBefore(ActorClock.currentTimeMillis(), timer -> {
            this.timerRecord.reset();
            this.timerRecord.setElementInstanceKey(timer.getElementInstanceKey()).setProcessInstanceKey(timer.getProcessInstanceKey()).setDueDate(timer.getDueDate()).setTargetElementId(timer.getHandlerNodeId()).setRepetitions(timer.getRepetitions()).setProcessDefinitionKey(timer.getProcessDefinitionKey());
            typedCommandWriter.reset();
            typedCommandWriter.appendFollowUpCommand(timer.getKey(), (Intent)TimerIntent.TRIGGER, (RecordValue)this.timerRecord);
            return typedCommandWriter.flush() > 0L;
        }));
    }

    public void scheduleTimer(long dueDate) {
        this.dueDateChecker.schedule(dueDate);
    }

    @Override
    public void onRecovered(ReadonlyProcessingContext context) {
        this.dueDateChecker.onRecovered(context);
    }

    @Override
    public void onClose() {
        this.dueDateChecker.onClose();
    }

    @Override
    public void onFailed() {
        this.dueDateChecker.onFailed();
    }

    @Override
    public void onPaused() {
        this.dueDateChecker.onPaused();
    }

    @Override
    public void onResumed() {
        this.dueDateChecker.onResumed();
    }
}

