/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.instance;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.engine.state.ZbColumnFamilies;
import io.camunda.zeebe.engine.state.instance.EventScopeInstance;
import io.camunda.zeebe.engine.state.instance.EventTrigger;
import io.camunda.zeebe.engine.state.mutable.MutableEventScopeInstanceState;
import java.util.Collection;
import org.agrona.DirectBuffer;

public final class DbEventScopeInstanceState
implements MutableEventScopeInstanceState {
    private final DbLong eventScopeKey = new DbLong();
    private final EventScopeInstance eventScopeInstance = new EventScopeInstance();
    private final ColumnFamily<DbLong, EventScopeInstance> eventScopeInstanceColumnFamily;
    private final DbLong eventTriggerScopeKey;
    private final DbLong eventTriggerEventKey;
    private final DbCompositeKey<DbLong, DbLong> eventTriggerKey;
    private final EventTrigger eventTrigger;
    private final ColumnFamily<DbCompositeKey<DbLong, DbLong>, EventTrigger> eventTriggerColumnFamily;

    public DbEventScopeInstanceState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.eventScopeInstanceColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.EVENT_SCOPE, transactionContext, (DbKey)this.eventScopeKey, (DbValue)this.eventScopeInstance);
        this.eventTriggerScopeKey = new DbLong();
        this.eventTriggerEventKey = new DbLong();
        this.eventTriggerKey = new DbCompositeKey((DbKey)this.eventTriggerScopeKey, (DbKey)this.eventTriggerEventKey);
        this.eventTrigger = new EventTrigger();
        this.eventTriggerColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.EVENT_TRIGGER, transactionContext, this.eventTriggerKey, (DbValue)this.eventTrigger);
    }

    @Override
    public void shutdownInstance(long eventScopeKey) {
        EventScopeInstance instance = this.getInstance(eventScopeKey);
        if (instance != null) {
            this.eventScopeKey.wrapLong(eventScopeKey);
            instance.setAccepting(false);
            this.eventScopeInstanceColumnFamily.put((DbKey)this.eventScopeKey, (DbValue)instance);
        }
    }

    @Override
    public boolean createIfNotExists(long eventScopeKey, Collection<DirectBuffer> interruptingIds) {
        this.eventScopeKey.wrapLong(eventScopeKey);
        boolean wasCreated = false;
        if (!this.eventScopeInstanceColumnFamily.exists((DbKey)this.eventScopeKey)) {
            this.createInstance(eventScopeKey, interruptingIds);
            wasCreated = true;
        }
        return wasCreated;
    }

    @Override
    public void createInstance(long eventScopeKey, Collection<DirectBuffer> interruptingIds) {
        this.eventScopeInstance.reset();
        this.eventScopeKey.wrapLong(eventScopeKey);
        this.eventScopeInstance.setAccepting(true);
        for (DirectBuffer interruptingId : interruptingIds) {
            this.eventScopeInstance.addInterrupting(interruptingId);
        }
        this.eventScopeInstanceColumnFamily.put((DbKey)this.eventScopeKey, (DbValue)this.eventScopeInstance);
    }

    @Override
    public void deleteInstance(long eventScopeKey) {
        this.eventTriggerScopeKey.wrapLong(eventScopeKey);
        this.eventTriggerColumnFamily.whileEqualPrefix((DbKey)this.eventTriggerScopeKey, (key, value) -> this.deleteTrigger((DbCompositeKey<DbLong, DbLong>)key));
        this.eventScopeKey.wrapLong(eventScopeKey);
        this.eventScopeInstanceColumnFamily.delete((DbKey)this.eventScopeKey);
    }

    @Override
    public EventTrigger pollEventTrigger(long eventScopeKey) {
        this.eventTriggerScopeKey.wrapLong(eventScopeKey);
        EventTrigger[] next = new EventTrigger[1];
        this.eventTriggerColumnFamily.whileEqualPrefix((DbKey)this.eventTriggerScopeKey, (key, value) -> {
            next[0] = new EventTrigger((EventTrigger)value);
            this.deleteTrigger((DbCompositeKey<DbLong, DbLong>)key);
            return false;
        });
        return next[0];
    }

    @Override
    public void triggerEvent(long eventScopeKey, long eventKey, DirectBuffer elementId, DirectBuffer variables) {
        this.eventScopeKey.wrapLong(eventScopeKey);
        EventScopeInstance instance = (EventScopeInstance)this.eventScopeInstanceColumnFamily.get((DbKey)this.eventScopeKey);
        if (this.isAcceptingEvent(instance)) {
            if (instance.isInterrupting(elementId)) {
                instance.setAccepting(false);
                this.eventScopeInstanceColumnFamily.put((DbKey)this.eventScopeKey, (DbValue)instance);
            }
            this.createTrigger(eventScopeKey, eventKey, elementId, variables);
        }
    }

    @Override
    public void triggerStartEvent(long processDefinitionKey, long eventKey, DirectBuffer elementId, DirectBuffer variables) {
        this.createTrigger(processDefinitionKey, eventKey, elementId, variables);
    }

    @Override
    public void deleteTrigger(long eventScopeKey, long eventKey) {
        this.eventTriggerScopeKey.wrapLong(eventScopeKey);
        this.eventTriggerEventKey.wrapLong(eventKey);
        this.deleteTrigger(this.eventTriggerKey);
    }

    @Override
    public EventScopeInstance getInstance(long eventScopeKey) {
        this.eventScopeKey.wrapLong(eventScopeKey);
        EventScopeInstance instance = (EventScopeInstance)this.eventScopeInstanceColumnFamily.get((DbKey)this.eventScopeKey);
        return instance != null ? new EventScopeInstance(instance) : null;
    }

    @Override
    public EventTrigger peekEventTrigger(long eventScopeKey) {
        this.eventTriggerScopeKey.wrapLong(eventScopeKey);
        EventTrigger[] next = new EventTrigger[1];
        this.eventTriggerColumnFamily.whileEqualPrefix((DbKey)this.eventTriggerScopeKey, (key, value) -> {
            next[0] = new EventTrigger((EventTrigger)value);
            return false;
        });
        return next[0];
    }

    @Override
    public boolean isAcceptingEvent(long eventScopeKey) {
        this.eventScopeKey.wrapLong(eventScopeKey);
        EventScopeInstance instance = (EventScopeInstance)this.eventScopeInstanceColumnFamily.get((DbKey)this.eventScopeKey);
        return this.isAcceptingEvent(instance);
    }

    private boolean isAcceptingEvent(EventScopeInstance instance) {
        return instance != null && instance.isAccepting();
    }

    private void createTrigger(long eventScopeKey, long eventKey, DirectBuffer elementId, DirectBuffer variables) {
        this.eventTriggerScopeKey.wrapLong(eventScopeKey);
        this.eventTriggerEventKey.wrapLong(eventKey);
        this.eventTrigger.setElementId(elementId).setVariables(variables).setEventKey(eventKey);
        this.eventTriggerColumnFamily.put(this.eventTriggerKey, (DbValue)this.eventTrigger);
    }

    private void deleteTrigger(DbCompositeKey<DbLong, DbLong> triggerKey) {
        this.eventTriggerColumnFamily.delete(triggerKey);
    }
}

