/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.sched.channel;

import io.camunda.zeebe.util.sched.ActorCondition;
import java.util.concurrent.atomic.AtomicReference;

public final class ActorConditions {
    private static final int JNI_COPY_TO_ARRAY_THRESHOLD = 6;
    private static final ActorCondition[] EMPTY_ARRAY = new ActorCondition[0];
    private final AtomicReference<ActorCondition[]> arrayRef = new AtomicReference<ActorCondition[]>(EMPTY_ARRAY);

    public void registerConsumer(ActorCondition item) {
        ActorCondition[] newArray;
        ActorCondition[] oldArray;
        if (null == item) {
            throw new NullPointerException("null items are not supported in this collection");
        }
        do {
            oldArray = this.arrayRef.get();
            int oldLength = oldArray.length;
            newArray = new ActorCondition[oldLength + 1];
            ActorConditions.copyArray(oldArray, 0, newArray, 0, oldLength);
            newArray[oldLength] = item;
        } while (!this.arrayRef.compareAndSet(oldArray, newArray));
    }

    public void removeConsumer(ActorCondition item) {
        ActorCondition[] newArray;
        ActorCondition[] oldArray;
        if (null == item) {
            throw new NullPointerException("null items are not supported in this collection");
        }
        do {
            int index;
            if (-1 == (index = ActorConditions.find(oldArray = this.arrayRef.get(), item))) {
                return;
            }
            int newLength = oldArray.length - 1;
            newArray = new ActorCondition[newLength];
            ActorConditions.copyArray(oldArray, 0, newArray, 0, index);
            ActorConditions.copyArray(oldArray, index + 1, newArray, index, newLength - index);
        } while (!this.arrayRef.compareAndSet(oldArray, newArray));
    }

    public void signalConsumers() {
        ActorCondition[] consumer = this.arrayRef.get();
        for (int i = 0; i < consumer.length; ++i) {
            consumer[i].signal();
        }
    }

    private static int find(ActorCondition[] array, ActorCondition condition) {
        for (int i = 0; i < array.length; ++i) {
            if (!condition.equals(array[i])) continue;
            return i;
        }
        return -1;
    }

    private static void copyArray(ActorCondition[] src, int srcPos, ActorCondition[] dest, int destPos, int length) {
        if (length < 6) {
            int srcIndex = srcPos;
            int endIndex = destPos + length;
            for (int destIndex = destPos; destIndex < endIndex; ++destIndex) {
                dest[destIndex] = src[srcIndex];
                ++srcIndex;
            }
        } else {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }
    }
}

