/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker;

import io.camunda.zeebe.broker.Loggers;
import io.camunda.zeebe.broker.PartitionListener;
import io.camunda.zeebe.broker.SpringBrokerBridge;
import io.camunda.zeebe.broker.bootstrap.BrokerContext;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContextImpl;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupProcess;
import io.camunda.zeebe.broker.exporter.repo.ExporterLoadException;
import io.camunda.zeebe.broker.exporter.repo.ExporterRepository;
import io.camunda.zeebe.broker.system.SystemContext;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ClusterCfg;
import io.camunda.zeebe.broker.system.configuration.ExporterCfg;
import io.camunda.zeebe.broker.system.monitoring.BrokerHealthCheckService;
import io.camunda.zeebe.protocol.impl.encoding.BrokerInfo;
import io.camunda.zeebe.util.LogUtil;
import io.camunda.zeebe.util.VersionUtil;
import io.camunda.zeebe.util.exception.UncheckedExecutionException;
import io.camunda.zeebe.util.jar.ExternalJarLoadException;
import io.camunda.zeebe.util.sched.Actor;
import io.camunda.zeebe.util.sched.ActorScheduler;
import io.camunda.zeebe.util.sched.ConcurrencyControl;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import io.netty.util.NetUtil;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.slf4j.Logger;

public final class Broker
implements AutoCloseable {
    public static final Logger LOG = Loggers.SYSTEM_LOGGER;
    private final SystemContext systemContext;
    private boolean isClosed = false;
    private CompletableFuture<Broker> startFuture;
    private final ActorScheduler scheduler;
    private BrokerHealthCheckService healthCheckService;
    private final BrokerStartupActor brokerStartupActor;
    private final BrokerInfo localBroker;
    private BrokerContext brokerContext;

    public Broker(SystemContext systemContext, SpringBrokerBridge springBrokerBridge) {
        this(systemContext, springBrokerBridge, Collections.emptyList());
    }

    public Broker(SystemContext systemContext, SpringBrokerBridge springBrokerBridge, List<PartitionListener> additionalPartitionListeners) {
        this.systemContext = systemContext;
        this.scheduler = this.systemContext.getScheduler();
        this.localBroker = this.createBrokerInfo(this.getConfig());
        this.healthCheckService = new BrokerHealthCheckService(this.localBroker);
        BrokerStartupContextImpl startupContext = new BrokerStartupContextImpl(this.localBroker, systemContext.getBrokerConfiguration(), springBrokerBridge, this.scheduler, this.healthCheckService, this.buildExporterRepository(this.getConfig()), additionalPartitionListeners);
        this.brokerStartupActor = new BrokerStartupActor(startupContext);
        this.scheduler.submitActor((Actor)this.brokerStartupActor);
    }

    public synchronized CompletableFuture<Broker> start() {
        if (this.startFuture == null) {
            this.logBrokerStart();
            this.startFuture = new CompletableFuture();
            LogUtil.doWithMDC(this.systemContext.getDiagnosticContext(), this::internalStart);
        }
        return this.startFuture;
    }

    private void logBrokerStart() {
        if (LOG.isInfoEnabled()) {
            BrokerCfg brokerCfg = this.getConfig();
            LOG.info("Version: {}", (Object)VersionUtil.getVersion());
            LOG.info("Starting broker {} with configuration {}", (Object)brokerCfg.getCluster().getNodeId(), (Object)brokerCfg.toJson());
        }
    }

    private void internalStart() {
        try {
            this.brokerContext = (BrokerContext)this.brokerStartupActor.start().join();
            this.healthCheckService.setBrokerStarted();
            this.startFuture.complete(this);
        }
        catch (Exception bootStrapException) {
            BrokerCfg brokerCfg = this.getConfig();
            LOG.error("Failed to start broker {}!", (Object)brokerCfg.getCluster().getNodeId(), (Object)bootStrapException);
            UncheckedExecutionException exception = new UncheckedExecutionException("Failed to start broker", (Throwable)bootStrapException);
            this.startFuture.completeExceptionally((Throwable)exception);
            throw exception;
        }
    }

    private BrokerInfo createBrokerInfo(BrokerCfg brokerCfg) {
        ClusterCfg clusterCfg = brokerCfg.getCluster();
        BrokerInfo result = new BrokerInfo(clusterCfg.getNodeId(), NetUtil.toSocketAddressString((InetSocketAddress)brokerCfg.getNetwork().getCommandApi().getAdvertisedAddress()));
        result.setClusterSize(clusterCfg.getClusterSize()).setPartitionsCount(clusterCfg.getPartitionsCount()).setReplicationFactor(clusterCfg.getReplicationFactor());
        String version = VersionUtil.getVersion();
        if (version != null && !version.isBlank()) {
            result.setVersion(version);
        }
        return result;
    }

    private ExporterRepository buildExporterRepository(BrokerCfg cfg) {
        ExporterRepository exporterRepository = new ExporterRepository();
        Set<Map.Entry<String, ExporterCfg>> exporterEntries = cfg.getExporters().entrySet();
        for (Map.Entry<String, ExporterCfg> exporterEntry : exporterEntries) {
            String id = exporterEntry.getKey();
            ExporterCfg exporterCfg = exporterEntry.getValue();
            try {
                exporterRepository.load(id, exporterCfg);
            }
            catch (ExporterLoadException | ExternalJarLoadException e) {
                throw new IllegalStateException("Failed to load exporter with configuration: " + exporterCfg, e);
            }
        }
        return exporterRepository;
    }

    public BrokerCfg getConfig() {
        return this.systemContext.getBrokerConfiguration();
    }

    @Override
    public void close() {
        LogUtil.doWithMDC(this.systemContext.getDiagnosticContext(), () -> {
            if (!this.isClosed && this.startFuture != null) {
                ((CompletableFuture)this.startFuture.thenAccept(b -> {
                    this.brokerStartupActor.stop().join();
                    this.healthCheckService = null;
                    this.isClosed = true;
                    LOG.info("Broker shut down.");
                })).join();
            }
        });
    }

    public BrokerContext getBrokerContext() {
        return this.brokerContext;
    }

    public SystemContext getSystemContext() {
        return this.systemContext;
    }

    private static final class BrokerStartupActor
    extends Actor {
        private final BrokerStartupProcess brokerStartupProcess;
        private final int nodeId;

        private BrokerStartupActor(BrokerStartupContextImpl startupContext) {
            this.nodeId = startupContext.getBrokerInfo().getNodeId();
            startupContext.setConcurrencyControl((ConcurrencyControl)this.actor);
            this.brokerStartupProcess = new BrokerStartupProcess(startupContext);
        }

        public String getName() {
            return BrokerStartupActor.buildActorName((int)this.nodeId, (String)"Startup");
        }

        private ActorFuture<BrokerContext> start() {
            ActorFuture result = this.createFuture();
            this.actor.run(() -> this.actor.runOnCompletion(this.brokerStartupProcess.start(), (BiConsumer)result));
            return result;
        }

        private ActorFuture<Void> stop() {
            ActorFuture result = this.createFuture();
            this.actor.run(() -> this.actor.runOnCompletion(this.brokerStartupProcess.stop(), (BiConsumer)result));
            return result;
        }
    }
}

