/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.camunda.zeebe.broker.bootstrap.AbstractBrokerStartupStep;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.system.configuration.DataCfg;
import io.camunda.zeebe.broker.system.monitoring.DiskSpaceUsageMonitor;
import io.camunda.zeebe.util.FileUtil;
import io.camunda.zeebe.util.sched.Actor;
import io.camunda.zeebe.util.sched.ConcurrencyControl;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

class DiskSpaceUsageMonitorStep
extends AbstractBrokerStartupStep {
    DiskSpaceUsageMonitorStep() {
    }

    @Override
    void startupInternal(BrokerStartupContext brokerStartupContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> startupFuture) {
        DataCfg data = brokerStartupContext.getBrokerConfiguration().getData();
        try {
            FileUtil.ensureDirectoryExists((Path)Paths.get(data.getDirectory(), new String[0]));
        }
        catch (IOException e) {
            startupFuture.completeExceptionally((Throwable)e);
            return;
        }
        DiskSpaceUsageMonitor diskSpaceUsageMonitor = new DiskSpaceUsageMonitor(data);
        ActorFuture actorStartFuture = brokerStartupContext.getActorSchedulingService().submitActor((Actor)diskSpaceUsageMonitor);
        brokerStartupContext.getConcurrencyControl().runOnCompletion(actorStartFuture, (ok, error) -> {
            if (error != null) {
                startupFuture.completeExceptionally(error);
                return;
            }
            brokerStartupContext.setDiskSpaceUsageMonitor(diskSpaceUsageMonitor);
            startupFuture.complete((Object)brokerStartupContext);
        });
    }

    @Override
    void shutdownInternal(BrokerStartupContext brokerShutdownContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> shutdownFuture) {
        DiskSpaceUsageMonitor diskSpaceUsageMonitor = brokerShutdownContext.getDiskSpaceUsageMonitor();
        if (diskSpaceUsageMonitor != null) {
            ActorFuture closeFuture = diskSpaceUsageMonitor.closeAsync();
            concurrencyControl.runOnCompletion(closeFuture, (ok, error) -> {
                if (error != null) {
                    shutdownFuture.completeExceptionally(error);
                    return;
                }
                this.forwardExceptions(() -> concurrencyControl.run(() -> this.forwardExceptions(() -> {
                    brokerShutdownContext.setDiskSpaceUsageMonitor(null);
                    shutdownFuture.complete((Object)brokerShutdownContext);
                }, shutdownFuture)), shutdownFuture);
            });
        } else {
            shutdownFuture.complete((Object)brokerShutdownContext);
        }
    }

    public String getName() {
        return "Disk Space Usage Monitor";
    }
}

