/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.bootstrap;

import io.camunda.zeebe.broker.SpringBrokerBridge;
import io.camunda.zeebe.broker.bootstrap.AbstractBrokerStartupStep;
import io.camunda.zeebe.broker.bootstrap.BrokerStartupContext;
import io.camunda.zeebe.broker.clustering.ClusterServicesImpl;
import io.camunda.zeebe.broker.system.EmbeddedGatewayService;
import io.camunda.zeebe.gateway.Gateway;
import io.camunda.zeebe.util.sched.ConcurrencyControl;
import io.camunda.zeebe.util.sched.future.ActorFuture;
import java.util.concurrent.CompletableFuture;

class EmbeddedGatewayServiceStep
extends AbstractBrokerStartupStep {
    EmbeddedGatewayServiceStep() {
    }

    public String getName() {
        return "Embedded Gateway";
    }

    @Override
    void startupInternal(BrokerStartupContext brokerStartupContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> startupFuture) {
        ClusterServicesImpl clusterServices = brokerStartupContext.getClusterServices();
        EmbeddedGatewayService embeddedGatewayService = new EmbeddedGatewayService(brokerStartupContext.getBrokerConfiguration(), brokerStartupContext.getActorScheduler(), clusterServices.getMessagingService(), clusterServices.getMembershipService(), clusterServices.getEventService());
        brokerStartupContext.setEmbeddedGatewayService(embeddedGatewayService);
        SpringBrokerBridge springBridge = brokerStartupContext.getSpringBrokerBridge();
        Gateway gateway = embeddedGatewayService.get();
        springBridge.registerBrokerClient(() -> ((Gateway)gateway).getBrokerClient());
        startupFuture.complete((Object)brokerStartupContext);
    }

    @Override
    void shutdownInternal(BrokerStartupContext brokerShutdownContext, ConcurrencyControl concurrencyControl, ActorFuture<BrokerStartupContext> shutdownFuture) {
        EmbeddedGatewayService embeddedGatewayService = brokerShutdownContext.getEmbeddedGatewayService();
        if (embeddedGatewayService == null) {
            shutdownFuture.complete((Object)brokerShutdownContext);
            return;
        }
        CompletableFuture.runAsync(embeddedGatewayService::close).whenComplete((ok, error) -> {
            if (error != null) {
                shutdownFuture.completeExceptionally(error);
            } else {
                concurrencyControl.run(() -> this.forwardExceptions(() -> {
                    brokerShutdownContext.setEmbeddedGatewayService(null);
                    shutdownFuture.complete((Object)brokerShutdownContext);
                }, shutdownFuture));
            }
        });
    }
}

