/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.debug;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Charsets;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import io.camunda.zeebe.protocol.record.Record;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.LinkedList;

@Deprecated(since="1.3", forRemoval=true)
public final class DebugHttpServer {
    private static final Charset CHARSET = Charsets.UTF_8;
    private final int maxSize;
    private final LinkedList<String> records;
    private HttpServer server;

    public DebugHttpServer(int port, int maxSize) {
        this.maxSize = maxSize;
        this.server = this.startHttpServer(port);
        this.records = new LinkedList();
    }

    public void close() {
        if (this.server != null) {
            this.server.stop(0);
            this.server = null;
        }
    }

    private HttpServer startHttpServer(int port) {
        try {
            HttpServer httpServer = HttpServer.create(new InetSocketAddress(port), 0);
            httpServer.createContext("/", new RequestHandler());
            httpServer.start();
            return this.server;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to start debug exporter http server", e);
        }
    }

    public synchronized void add(Record record) throws JsonProcessingException {
        while (this.records.size() >= this.maxSize) {
            this.records.removeLast();
        }
        this.records.addFirst(record.toJson());
    }

    class RequestHandler
    implements HttpHandler {
        RequestHandler() {
        }

        @Override
        public void handle(HttpExchange httpExchange) throws IOException {
            String path = httpExchange.getRequestURI().getPath().substring(1);
            if ("records.json".equals(path)) {
                byte[] response = this.getRecords();
                httpExchange.getResponseHeaders().add("Content-Type", "application/json");
                httpExchange.sendResponseHeaders(200, response.length);
                try (OutputStream outputStream = httpExchange.getResponseBody();){
                    outputStream.write(response);
                }
            } else {
                httpExchange.getResponseHeaders().add("Location", "/records.json");
                httpExchange.sendResponseHeaders(302, -1L);
            }
        }

        private byte[] getRecords() {
            String json = "[" + String.join((CharSequence)",", DebugHttpServer.this.records) + "]";
            return json.getBytes(CHARSET);
        }
    }
}

