/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.auth;

import io.camunda.operate.CamundaOperateClient;
import io.camunda.operate.auth.AuthInterface;
import io.camunda.operate.exception.OperateException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicNameValuePair;

public class SimpleAuthentication
implements AuthInterface {
    private String operateUsername;
    private String operatePassword;
    private String operateUrl;

    public SimpleAuthentication(String operateUsername, String operatePassword, String operateUrl) {
        this.operateUsername = operateUsername;
        this.operatePassword = operatePassword;
        this.operateUrl = operateUrl;
    }

    @Override
    public void authenticate(CamundaOperateClient client) throws OperateException {
        HttpPost httpPost = new HttpPost(this.operateUrl + "/api/login");
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("username", this.operateUsername));
        params.add(new BasicNameValuePair("password", this.operatePassword));
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        try (CloseableHttpClient httpClient = HttpClients.createDefault();
             CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)httpPost);){
            String cookie = response.getHeader("Set-Cookie").getValue();
            client.setAuthHeader((Header)new BasicHeader("Cookie", (Object)cookie));
        }
        catch (IOException | ProtocolException e) {
            throw new OperateException((Exception)e);
        }
    }
}

