/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.search;

import io.camunda.operate.exception.OperateException;
import io.camunda.operate.search.Filter;
import io.camunda.operate.search.Sort;
import java.util.ArrayList;
import java.util.List;

public class SearchQuery {
    private Filter filter;
    private Integer size;
    private List<Sort> sort;

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public List<Sort> getSort() {
        return this.sort;
    }

    public void setSort(List<Sort> sort) {
        this.sort = sort;
    }

    public static class Builder {
        private Filter filter;
        private Integer size;
        private List<Sort> sorts = new ArrayList<Sort>();

        public Builder withFilter(Filter filter) {
            this.filter = filter;
            return this;
        }

        public Builder withSize(Integer size) {
            this.size = size;
            return this;
        }

        public Builder withSort(Sort sort) {
            this.sorts.add(sort);
            return this;
        }

        public SearchQuery build() throws OperateException {
            SearchQuery query = new SearchQuery();
            query.filter = this.filter;
            query.size = this.size;
            if (!this.sorts.isEmpty()) {
                query.setSort(this.sorts);
            }
            return query;
        }
    }
}

