/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate;

import io.camunda.operate.CamundaOperateConstants;
import io.camunda.operate.auth.AuthInterface;
import io.camunda.operate.beta.CamundaOperateBetaClient;
import io.camunda.operate.dto.FlownodeInstance;
import io.camunda.operate.dto.Incident;
import io.camunda.operate.dto.ProcessDefinition;
import io.camunda.operate.dto.ProcessInstance;
import io.camunda.operate.dto.SearchResult;
import io.camunda.operate.dto.Variable;
import io.camunda.operate.exception.OperateException;
import io.camunda.operate.search.SearchQuery;
import io.camunda.operate.util.JsonUtils;
import io.camunda.operate.util.QueryValidatorUtils;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;

public class CamundaOperateClient {
    private AuthInterface authentication;
    private String operateUrl;
    private Header authHeader;
    private int tokenExpiration;

    public ProcessDefinition getProcessDefinition(Long key) throws OperateException {
        return this.get(key, ProcessDefinition.class);
    }

    public List<ProcessDefinition> searchProcessDefinitions(SearchQuery query) throws OperateException {
        QueryValidatorUtils.verifyQuery(query, ProcessDefinition.class);
        return this.search(query, ProcessDefinition.class).getItems();
    }

    public SearchResult<ProcessDefinition> searchProcessDefinitionResults(SearchQuery query) throws OperateException {
        QueryValidatorUtils.verifyQuery(query, ProcessDefinition.class);
        return this.search(query, ProcessDefinition.class);
    }

    public String getProcessDefinitionXml(Long key) throws OperateException {
        String url = this.operateUrl + CamundaOperateConstants.OBJECT_APIS.get(ProcessDefinition.class) + "/" + key + "/xml";
        HttpGet httpGet = new HttpGet(url);
        httpGet.addHeader(this.authHeader);
        try {
            return this.executeQuery((ClassicHttpRequest)httpGet);
        }
        catch (OperateException e) {
            throw new OperateException("Error get Process Definition XML for " + key, e);
        }
    }

    /*
     * Exception decompiling
     */
    public BpmnModelInstance getProcessDefinitionModel(Long key) throws OperateException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public CloseableHttpResponse execute(CloseableHttpClient httpClient, ClassicHttpRequest request) throws IOException, OperateException {
        return this.execute(httpClient, request, 0);
    }

    private CloseableHttpResponse execute(CloseableHttpClient httpClient, ClassicHttpRequest request, int count) throws IOException, OperateException {
        CloseableHttpResponse response = httpClient.execute(request);
        if (response.getCode() == 401 && count <= 2) {
            this.authentication.authenticate(this);
            return this.execute(httpClient, request, ++count);
        }
        if (response.getCode() > 399) {
            throw this.createDetailedException(response, request);
        }
        return response;
    }

    private OperateException createDetailedException(CloseableHttpResponse response, ClassicHttpRequest request) throws IOException {
        String details = "";
        if (request instanceof HttpPost) {
            InputStream content = ((HttpPost)request).getEntity().getContent();
            String body = new BufferedReader(new InputStreamReader(content, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            details = details + "; Body : " + body;
        }
        return new OperateException(request.getPath() + " : " + response.getCode() + " " + response.getReasonPhrase() + details);
    }

    public ProcessInstance getProcessInstance(Long key) throws OperateException {
        return this.get(key, ProcessInstance.class);
    }

    public List<ProcessInstance> searchProcessInstances(SearchQuery query) throws OperateException {
        QueryValidatorUtils.verifyQuery(query, ProcessInstance.class);
        return this.search(query, ProcessInstance.class).getItems();
    }

    public SearchResult<ProcessInstance> searchProcessInstanceResults(SearchQuery query) throws OperateException {
        QueryValidatorUtils.verifyQuery(query, ProcessInstance.class);
        return this.search(query, ProcessInstance.class);
    }

    public FlownodeInstance getFlownodeInstance(Long key) throws OperateException {
        return this.get(key, FlownodeInstance.class);
    }

    public List<FlownodeInstance> searchFlownodeInstances(SearchQuery query) throws OperateException {
        QueryValidatorUtils.verifyQuery(query, FlownodeInstance.class);
        return this.search(query, FlownodeInstance.class).getItems();
    }

    public SearchResult<FlownodeInstance> searchFlownodeInstanceResults(SearchQuery query) throws OperateException {
        QueryValidatorUtils.verifyQuery(query, FlownodeInstance.class);
        return this.search(query, FlownodeInstance.class);
    }

    public Incident getIncident(Long key) throws OperateException {
        return this.get(key, Incident.class);
    }

    public List<Incident> searchIncidents(SearchQuery query) throws OperateException {
        QueryValidatorUtils.verifyQuery(query, Incident.class);
        return this.search(query, Incident.class).getItems();
    }

    public SearchResult<Incident> searchIncidentResults(SearchQuery query) throws OperateException {
        QueryValidatorUtils.verifyQuery(query, Incident.class);
        return this.search(query, Incident.class);
    }

    public Variable getVariable(Long key) throws OperateException {
        return this.get(key, Variable.class);
    }

    public List<Variable> searchVariables(SearchQuery query) throws OperateException {
        QueryValidatorUtils.verifyQuery(query, Variable.class);
        return this.search(query, Variable.class).getItems();
    }

    public SearchResult<Variable> searchVariableResults(SearchQuery query) throws OperateException {
        QueryValidatorUtils.verifyQuery(query, Variable.class);
        return this.search(query, Variable.class);
    }

    public <T> SearchResult<T> search(SearchQuery query, Class<T> resultType) throws OperateException {
        if (query == null || resultType == null) {
            throw new OperateException("Query and resultType shouldn't be null");
        }
        HttpPost httpPost = new HttpPost(this.operateUrl + CamundaOperateConstants.OBJECT_APIS.get(resultType) + "/search");
        httpPost.addHeader("Content-Type", (Object)"application/json");
        httpPost.addHeader(this.authHeader);
        try {
            String data = JsonUtils.toJson(query);
            httpPost.setEntity((HttpEntity)new StringEntity(data));
            return JsonUtils.toSearchResult(this.executeQuery((ClassicHttpRequest)httpPost), resultType);
        }
        catch (IOException e) {
            throw new OperateException("Error executing the SearchQuery", e);
        }
    }

    private <T> T get(Long key, Class<T> resultType) throws OperateException {
        if (key == null || resultType == null) {
            throw new OperateException("Key and resultType shouldn't be null");
        }
        String url = this.operateUrl + CamundaOperateConstants.OBJECT_APIS.get(resultType) + "/" + key;
        HttpGet httpGet = new HttpGet(url);
        httpGet.addHeader("Content-Type", (Object)"application/json");
        httpGet.addHeader(this.authHeader);
        try {
            return JsonUtils.toResult(this.executeQuery((ClassicHttpRequest)httpGet), resultType);
        }
        catch (IOException e) {
            throw new OperateException("Error executing get for (key : " + key + ")" + resultType.getName() + " on " + url, e);
        }
    }

    /*
     * Exception decompiling
     */
    protected String executeQuery(ClassicHttpRequest httpRequest) throws OperateException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getOperateUrl() {
        return this.operateUrl;
    }

    public void setOperateUrl(String operateUrl) {
        this.operateUrl = operateUrl;
    }

    public Header getAuthHeader() {
        return this.authHeader;
    }

    public void setAuthHeader(Header authHeader) {
        this.authHeader = authHeader;
    }

    public void setTokenExpiration(int tokenExpiration) {
        this.tokenExpiration = tokenExpiration;
    }

    private void reconnectEventually() throws OperateException {
        if (this.tokenExpiration > 0 && (long)this.tokenExpiration < System.currentTimeMillis() / 1000L - 3L) {
            this.authentication.authenticate(this);
        }
    }

    public static class Builder {
        private AuthInterface authentication;
        private String operateUrl;
        private boolean beta;

        public Builder beta() {
            this.beta = true;
            return this;
        }

        public Builder authentication(AuthInterface authentication) {
            this.authentication = authentication;
            return this;
        }

        public Builder operateUrl(String operateUrl) {
            this.operateUrl = this.formatUrl(operateUrl);
            return this;
        }

        public CamundaOperateClient build() throws OperateException {
            CamundaOperateClient client = this.beta ? new CamundaOperateBetaClient() : new CamundaOperateClient();
            client.authentication = this.authentication;
            client.operateUrl = this.operateUrl;
            this.authentication.authenticate(client);
            return client;
        }

        private String formatUrl(String url) {
            if (url.endsWith("/")) {
                return url.substring(0, url.length() - 1);
            }
            return url;
        }
    }
}

