/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.dto.SearchResult;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class JsonUtils {
    private static ObjectMapper mapper;
    private static Map<Class<?>, JavaType> searchResultTypeMap;

    private JsonUtils() {
    }

    private static ObjectMapper getObjectMapper() {
        if (mapper == null) {
            mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        return mapper;
    }

    public static JsonNode toJsonNode(InputStream is) throws IOException {
        return JsonUtils.getObjectMapper().readTree(is);
    }

    public static JsonNode toJsonNode(String json) throws IOException {
        return JsonUtils.getObjectMapper().readTree(json);
    }

    public static String toJson(Object object) throws IOException {
        return JsonUtils.getObjectMapper().writeValueAsString(object);
    }

    public static <T> T toResult(String json, Class<T> resultType) throws IOException {
        return (T)JsonUtils.getObjectMapper().readValue(json, resultType);
    }

    public static <T> SearchResult<T> toSearchResult(String json, Class<T> resultType) throws IOException {
        return (SearchResult)JsonUtils.getObjectMapper().readValue(json, JsonUtils.getSearchResultType(resultType));
    }

    private static JavaType getSearchResultType(Class<?> resultType) {
        if (!searchResultTypeMap.containsKey(resultType)) {
            searchResultTypeMap.put(resultType, JsonUtils.getObjectMapper().getTypeFactory().constructParametricType(SearchResult.class, new Class[]{resultType}));
        }
        return searchResultTypeMap.get(resultType);
    }

    static {
        searchResultTypeMap = new HashMap();
    }
}

