/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.api;

import io.camunda.process.test.api.CamundaAssert;
import io.camunda.process.test.api.CamundaProcessTestContext;
import io.camunda.process.test.impl.assertions.CamundaDataSource;
import io.camunda.process.test.impl.containers.CamundaContainer;
import io.camunda.process.test.impl.extension.CamundaProcessTestContextImpl;
import io.camunda.process.test.impl.runtime.CamundaContainerRuntime;
import io.camunda.process.test.impl.runtime.CamundaContainerRuntimeBuilder;
import io.camunda.zeebe.client.ZeebeClient;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.ReflectionUtils;

public class CamundaProcessTestExtension
implements BeforeEachCallback,
AfterEachCallback {
    public static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{CamundaProcessTestExtension.class});
    public static final String STORE_KEY_RUNTIME = "camunda-process-test-runtime";
    public static final String STORE_KEY_CONTEXT = "camunda-process-test-context";
    private final List<ZeebeClient> createdClients = new ArrayList<ZeebeClient>();
    private final CamundaContainerRuntimeBuilder containerRuntimeBuilder;
    private CamundaContainerRuntime containerRuntime;

    CamundaProcessTestExtension(CamundaContainerRuntimeBuilder containerRuntimeBuilder) {
        this.containerRuntimeBuilder = containerRuntimeBuilder;
    }

    public CamundaProcessTestExtension() {
        this(CamundaContainerRuntime.newBuilder());
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        this.containerRuntime = this.containerRuntimeBuilder.build();
        this.containerRuntime.start();
        CamundaProcessTestContextImpl camundaProcessTestContext = new CamundaProcessTestContextImpl(this.containerRuntime.getCamundaContainer(), this.containerRuntime.getConnectorsContainer(), this.createdClients::add);
        try {
            this.injectField(context, ZeebeClient.class, camundaProcessTestContext::createClient);
            this.injectField(context, CamundaProcessTestContext.class, () -> camundaProcessTestContext);
        }
        catch (Exception e) {
            this.createdClients.forEach(ZeebeClient::close);
            this.containerRuntime.close();
            throw e;
        }
        ExtensionContext.Store store = context.getStore(NAMESPACE);
        store.put((Object)STORE_KEY_RUNTIME, (Object)this.containerRuntime);
        store.put((Object)STORE_KEY_CONTEXT, (Object)camundaProcessTestContext);
        CamundaDataSource dataSource = this.createDataSource(this.containerRuntime);
        CamundaAssert.initialize(dataSource);
    }

    private <T> void injectField(ExtensionContext context, Class<T> injectionType, Supplier<T> injectionValue) {
        context.getRequiredTestInstances().getAllInstances().forEach(instance -> this.injectField(instance, injectionType, injectionValue));
    }

    private <T> void injectField(Object testInstance, Class<T> injectionType, Supplier<T> injectionValue) {
        ReflectionUtils.findFields(testInstance.getClass(), field -> ReflectionUtils.isNotStatic((Member)field) && field.getType().isAssignableFrom(injectionType), (ReflectionUtils.HierarchyTraversalMode)ReflectionUtils.HierarchyTraversalMode.TOP_DOWN).forEach(field -> {
            try {
                ((Field)ReflectionUtils.makeAccessible((AccessibleObject)field)).set(testInstance, injectionValue.get());
            }
            catch (Throwable t) {
                ExceptionUtils.throwAsUncheckedException((Throwable)t);
            }
        });
    }

    private CamundaDataSource createDataSource(CamundaContainerRuntime containerRuntime) {
        CamundaContainer camundaContainer = containerRuntime.getCamundaContainer();
        return new CamundaDataSource(camundaContainer.getRestApiAddress().toString());
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        CamundaAssert.reset();
        this.createdClients.forEach(ZeebeClient::close);
        this.containerRuntime.close();
    }

    public CamundaProcessTestExtension withCamundaVersion(String camundaVersion) {
        this.containerRuntimeBuilder.withCamundaDockerImageVersion(camundaVersion).withConnectorsDockerImageVersion(camundaVersion);
        return this;
    }

    public CamundaProcessTestExtension withCamundaDockerImageName(String dockerImageName) {
        this.containerRuntimeBuilder.withCamundaDockerImageName(dockerImageName);
        return this;
    }

    public CamundaProcessTestExtension withCamundaEnv(Map<String, String> envVars) {
        this.containerRuntimeBuilder.withCamundaEnv(envVars);
        return this;
    }

    public CamundaProcessTestExtension withCamundaEnv(String name, String value) {
        this.containerRuntimeBuilder.withCamundaEnv(name, value);
        return this;
    }

    public CamundaProcessTestExtension withCamundaExposedPort(int port) {
        this.containerRuntimeBuilder.withCamundaExposedPort(port);
        return this;
    }

    public CamundaProcessTestExtension withConnectorsEnabled(boolean enabled) {
        this.containerRuntimeBuilder.withConnectorsEnabled(enabled);
        return this;
    }

    public CamundaProcessTestExtension withConnectorsDockerImageName(String dockerImageName) {
        this.containerRuntimeBuilder.withConnectorsDockerImageName(dockerImageName);
        return this;
    }

    public CamundaProcessTestExtension withConnectorsDockerImageVersion(String dockerImageVersion) {
        this.containerRuntimeBuilder.withConnectorsDockerImageVersion(dockerImageVersion);
        return this;
    }

    public CamundaProcessTestExtension withConnectorsEnv(Map<String, String> envVars) {
        this.containerRuntimeBuilder.withConnectorsEnv(envVars);
        return this;
    }

    public CamundaProcessTestExtension withConnectorsEnv(String name, String value) {
        this.containerRuntimeBuilder.withConnectorsEnv(name, value);
        return this;
    }

    public CamundaProcessTestExtension withConnectorsSecret(String name, String value) {
        this.containerRuntimeBuilder.withConnectorsSecret(name, value);
        return this;
    }
}

