/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.assertions;

import io.camunda.process.test.impl.client.CamundaApiClient;
import io.camunda.process.test.impl.client.FlowNodeInstanceDto;
import io.camunda.process.test.impl.client.ProcessInstanceDto;
import io.camunda.process.test.impl.client.VariableDto;
import java.io.IOException;
import java.util.List;

public class CamundaDataSource {
    private final CamundaApiClient camundaApiClient;

    public CamundaDataSource(String camundaApiEndpoint) {
        this.camundaApiClient = new CamundaApiClient(camundaApiEndpoint);
    }

    public ProcessInstanceDto getProcessInstance(long processInstanceKey) throws IOException {
        return this.camundaApiClient.getProcessInstanceByKey(processInstanceKey);
    }

    public List<FlowNodeInstanceDto> getFlowNodeInstancesByProcessInstanceKey(long processInstanceKey) throws IOException {
        return this.camundaApiClient.findFlowNodeInstancesByProcessInstanceKey(processInstanceKey).getItems();
    }

    public List<VariableDto> getVariablesByProcessInstanceKey(long processInstanceKey) throws IOException {
        return this.camundaApiClient.findVariablesByProcessInstanceKey(processInstanceKey).getItems();
    }
}

