/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.extension;

import io.camunda.process.test.api.CamundaProcessTestContext;
import io.camunda.process.test.impl.client.CamundaManagementClient;
import io.camunda.process.test.impl.containers.CamundaContainer;
import io.camunda.process.test.impl.containers.ConnectorsContainer;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.ZeebeClientBuilder;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Consumer;

public class CamundaProcessTestContextImpl
implements CamundaProcessTestContext {
    private final CamundaContainer camundaContainer;
    private final ConnectorsContainer connectorsContainer;
    private final Consumer<ZeebeClient> clientCreationCallback;
    private final CamundaManagementClient camundaManagementClient;

    public CamundaProcessTestContextImpl(CamundaContainer camundaContainer, ConnectorsContainer connectorsContainer, Consumer<ZeebeClient> clientCreationCallback) {
        this.camundaContainer = camundaContainer;
        this.connectorsContainer = connectorsContainer;
        this.clientCreationCallback = clientCreationCallback;
        this.camundaManagementClient = new CamundaManagementClient(camundaContainer.getMonitoringApiAddress());
    }

    @Override
    public ZeebeClient createClient() {
        return this.createClient(builder -> {});
    }

    @Override
    public ZeebeClient createClient(Consumer<ZeebeClientBuilder> modifier) {
        ZeebeClientBuilder builder = ZeebeClient.newClientBuilder().usePlaintext().grpcAddress(this.getCamundaGrpcAddress()).restAddress(this.getCamundaRestAddress());
        modifier.accept(builder);
        ZeebeClient client = builder.build();
        this.clientCreationCallback.accept(client);
        return client;
    }

    @Override
    public URI getCamundaGrpcAddress() {
        return this.camundaContainer.getGrpcApiAddress();
    }

    @Override
    public URI getCamundaRestAddress() {
        return this.camundaContainer.getRestApiAddress();
    }

    @Override
    public URI getConnectorsAddress() {
        return this.connectorsContainer.getRestApiAddress();
    }

    @Override
    public Instant getCurrentTime() {
        return this.camundaManagementClient.getCurrentTime();
    }

    @Override
    public void increaseTime(Duration timeToAdd) {
        this.camundaManagementClient.increaseTime(timeToAdd);
    }
}

