/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.runtime;

import io.camunda.process.test.impl.containers.CamundaContainer;
import io.camunda.process.test.impl.containers.ConnectorsContainer;
import io.camunda.process.test.impl.containers.ContainerFactory;
import io.camunda.process.test.impl.runtime.CamundaContainerRuntimeBuilder;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.elasticsearch.ElasticsearchContainer;

public class CamundaContainerRuntime
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamundaContainerRuntime.class);
    private static final String NETWORK_ALIAS_CAMUNDA = "camunda";
    private static final String NETWORK_ALIAS_ELASTICSEARCH = "elasticsearch";
    private static final String NETWORK_ALIAS_CONNECTORS = "connectors";
    private static final String ELASTICSEARCH_URL = "http://elasticsearch:9200";
    private static final String CAMUNDA_GRPC_API = "camunda:26500";
    private static final String CAMUNDA_REST_API = "http://camunda:8080";
    private final ContainerFactory containerFactory;
    private final Network network;
    private final CamundaContainer camundaContainer;
    private final ElasticsearchContainer elasticsearchContainer;
    private final ConnectorsContainer connectorsContainer;
    private final boolean connectorsEnabled;

    CamundaContainerRuntime(CamundaContainerRuntimeBuilder builder, ContainerFactory containerFactory) {
        this.containerFactory = containerFactory;
        this.connectorsEnabled = builder.isConnectorsEnabled();
        this.network = Network.newNetwork();
        this.elasticsearchContainer = this.createElasticsearchContainer(this.network, builder);
        this.camundaContainer = this.createCamundaContainer(this.network, builder);
        this.connectorsContainer = this.createConnectorsContainer(this.network, builder);
    }

    private ElasticsearchContainer createElasticsearchContainer(Network network, CamundaContainerRuntimeBuilder builder) {
        ElasticsearchContainer container = (ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)this.containerFactory.createElasticsearchContainer(builder.getElasticsearchDockerImageName(), builder.getElasticsearchDockerImageVersion()).withLogConsumer((Consumer)CamundaContainerRuntime.createContainerLogger(builder.getElasticsearchLoggerName()))).withNetwork(network)).withNetworkAliases(new String[]{NETWORK_ALIAS_ELASTICSEARCH})).withEnv("xpack.security.enabled", "false")).withEnv(builder.getElasticsearchEnvVars());
        builder.getElasticsearchExposedPorts().forEach(arg_0 -> ((ElasticsearchContainer)container).addExposedPort(arg_0));
        return container;
    }

    private CamundaContainer createCamundaContainer(Network network, CamundaContainerRuntimeBuilder builder) {
        CamundaContainer container = (CamundaContainer)((CamundaContainer)((CamundaContainer)((CamundaContainer)this.containerFactory.createCamundaContainer(builder.getCamundaDockerImageName(), builder.getCamundaDockerImageVersion()).withLogConsumer((Consumer)CamundaContainerRuntime.createContainerLogger(builder.getCamundaLoggerName()))).withNetwork(network)).withNetworkAliases(new String[]{NETWORK_ALIAS_CAMUNDA})).withElasticsearchUrl(ELASTICSEARCH_URL).withEnv(builder.getCamundaEnvVars());
        builder.getCamundaExposedPorts().forEach(arg_0 -> ((CamundaContainer)container).addExposedPort(arg_0));
        return container;
    }

    private ConnectorsContainer createConnectorsContainer(Network network, CamundaContainerRuntimeBuilder builder) {
        ConnectorsContainer container = (ConnectorsContainer)((ConnectorsContainer)((ConnectorsContainer)((ConnectorsContainer)((ConnectorsContainer)this.containerFactory.createConnectorsContainer(builder.getConnectorsDockerImageName(), builder.getConnectorsDockerImageVersion()).withLogConsumer((Consumer)CamundaContainerRuntime.createContainerLogger(builder.getConnectorsLoggerName()))).withNetwork(network)).withNetworkAliases(new String[]{NETWORK_ALIAS_CONNECTORS})).withZeebeGrpcApi(CAMUNDA_GRPC_API).withOperateApi(CAMUNDA_REST_API).withEnv(builder.getConnectorsSecrets())).withEnv(builder.getConnectorsEnvVars());
        builder.getConnectorsExposedPorts().forEach(arg_0 -> ((ConnectorsContainer)container).addExposedPort(arg_0));
        return container;
    }

    public void start() {
        LOGGER.info("Starting Camunda container runtime");
        Instant startTime = Instant.now();
        this.elasticsearchContainer.start();
        this.camundaContainer.start();
        if (this.connectorsEnabled) {
            this.connectorsContainer.start();
        }
        Instant endTime = Instant.now();
        Duration startupTime = Duration.between(startTime, endTime);
        LOGGER.info("Camunda container runtime started in {}", (Object)startupTime);
    }

    public CamundaContainer getCamundaContainer() {
        return this.camundaContainer;
    }

    public ElasticsearchContainer getElasticsearchContainer() {
        return this.elasticsearchContainer;
    }

    public ConnectorsContainer getConnectorsContainer() {
        return this.connectorsContainer;
    }

    @Override
    public void close() throws Exception {
        LOGGER.info("Stopping Camunda container runtime");
        Instant startTime = Instant.now();
        if (this.connectorsEnabled) {
            this.connectorsContainer.stop();
        }
        this.camundaContainer.stop();
        this.elasticsearchContainer.stop();
        this.network.close();
        Instant endTime = Instant.now();
        Duration shutdownTime = Duration.between(startTime, endTime);
        LOGGER.info("Camunda container runtime stopped in {}", (Object)shutdownTime);
    }

    private static Slf4jLogConsumer createContainerLogger(String name) {
        Logger logger = LoggerFactory.getLogger((String)name);
        return new Slf4jLogConsumer(logger);
    }

    public static CamundaContainerRuntimeBuilder newBuilder() {
        return new CamundaContainerRuntimeBuilder();
    }

    public static CamundaContainerRuntime newDefaultRuntime() {
        return CamundaContainerRuntime.newBuilder().build();
    }
}

