/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.assertions;

import io.camunda.process.test.api.assertions.ProcessInstanceAssert;
import io.camunda.process.test.impl.assertions.AssertFormatUtil;
import io.camunda.process.test.impl.assertions.CamundaDataSource;
import io.camunda.process.test.impl.assertions.VariableAssertj;
import io.camunda.process.test.impl.client.CamundaClientNotFoundException;
import io.camunda.process.test.impl.client.FlowNodeInstanceDto;
import io.camunda.process.test.impl.client.FlowNodeInstanceState;
import io.camunda.process.test.impl.client.ProcessInstanceDto;
import io.camunda.process.test.impl.client.ProcessInstanceState;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.awaitility.core.TerminalFailureException;

public class ProcessInstanceAssertj
extends AbstractAssert<ProcessInstanceAssertj, Long>
implements ProcessInstanceAssert {
    private final CamundaDataSource dataSource;
    private final VariableAssertj variableAssertj;

    public ProcessInstanceAssertj(CamundaDataSource dataSource, long processInstanceKey) {
        super((Object)processInstanceKey, ProcessInstanceAssertj.class);
        this.dataSource = dataSource;
        this.variableAssertj = new VariableAssertj(dataSource, processInstanceKey);
    }

    @Override
    public ProcessInstanceAssert isActive() {
        this.hasProcessInstanceInState(ProcessInstanceState.ACTIVE, Objects::nonNull);
        return this;
    }

    @Override
    public ProcessInstanceAssert isCompleted() {
        this.hasProcessInstanceInState(ProcessInstanceState.COMPLETED, ProcessInstanceAssertj::isEnded);
        return this;
    }

    @Override
    public ProcessInstanceAssert isTerminated() {
        this.hasProcessInstanceInState(ProcessInstanceState.TERMINATED, ProcessInstanceAssertj::isEnded);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasActiveElements(String ... elementNames) {
        this.hasElementsInState(elementNames, FlowNodeInstanceState.ACTIVE, Objects::nonNull);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasCompletedElements(String ... elementNames) {
        this.hasElementsInState(elementNames, FlowNodeInstanceState.COMPLETED, ProcessInstanceAssertj::isEnded);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasTerminatedElements(String ... elementNames) {
        this.hasElementsInState(elementNames, FlowNodeInstanceState.TERMINATED, ProcessInstanceAssertj::isEnded);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasVariableNames(String ... variableNames) {
        this.variableAssertj.hasVariableNames(variableNames);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasVariable(String variableName, Object variableValue) {
        this.variableAssertj.hasVariable(variableName, variableValue);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasVariables(Map<String, Object> variables) {
        this.variableAssertj.hasVariables(variables);
        return this;
    }

    private void hasProcessInstanceInState(ProcessInstanceState expectedState, Predicate<ProcessInstanceDto> waitCondition) {
        AtomicReference reference = new AtomicReference();
        try {
            Awaitility.await().ignoreException(CamundaClientNotFoundException.class).failFast(() -> waitCondition.test((ProcessInstanceDto)reference.get())).untilAsserted(() -> {
                ProcessInstanceDto processInstance = this.dataSource.getProcessInstance((Long)this.actual);
                reference.set(processInstance);
                Assertions.assertThat((Comparable)((Object)processInstance.getState())).isEqualTo((Object)expectedState);
            });
        }
        catch (ConditionTimeoutException | TerminalFailureException e) {
            String actualState = Optional.ofNullable((ProcessInstanceDto)reference.get()).map(ProcessInstanceDto::getState).map(ProcessInstanceAssertj::formatState).orElse("not activated");
            String failureMessage = String.format("%s should be %s but was %s.", AssertFormatUtil.formatProcessInstance((Long)this.actual), ProcessInstanceAssertj.formatState(expectedState), actualState);
            Assertions.fail((String)failureMessage);
        }
    }

    private void hasElementsInState(String[] elementNames, FlowNodeInstanceState expectedState, Predicate<FlowNodeInstanceDto> waitCondition) {
        AtomicReference reference = new AtomicReference(Collections.emptyList());
        List<String> elementNamesList = Arrays.asList(elementNames);
        try {
            Awaitility.await().ignoreException(CamundaClientNotFoundException.class).failFast(() -> ((List)reference.get()).stream().filter(waitCondition).map(FlowNodeInstanceDto::getFlowNodeName).collect(Collectors.toSet()).containsAll(elementNamesList)).untilAsserted(() -> {
                List<FlowNodeInstanceDto> flowNodeInstances = this.dataSource.getFlowNodeInstancesByProcessInstanceKey((Long)this.actual);
                reference.set(flowNodeInstances);
                ((ListAssert)Assertions.assertThat(flowNodeInstances).filteredOn(FlowNodeInstanceDto::getState, (Object)expectedState)).extracting(FlowNodeInstanceDto::getFlowNodeName).contains((Object[])elementNames);
            });
        }
        catch (ConditionTimeoutException | TerminalFailureException e) {
            Map<String, FlowNodeInstanceState> elementStateByName = reference.get().stream().filter(flowNode -> elementNamesList.contains(flowNode.getFlowNodeName())).collect(Collectors.toMap(FlowNodeInstanceDto::getFlowNodeName, FlowNodeInstanceDto::getState));
            String elementsNotInState = Arrays.stream(elementNames).filter(elementName -> !expectedState.equals(elementStateByName.get(elementName))).map(elementName -> String.format("\t- '%s': %s", elementName, ProcessInstanceAssertj.formatState((FlowNodeInstanceState)((Object)((Object)elementStateByName.get(elementName)))))).collect(Collectors.joining("\n"));
            String failureMessage = String.format("%s should have %s elements %s but the following elements were not %s:\n%s", AssertFormatUtil.formatProcessInstance((Long)this.actual), ProcessInstanceAssertj.formatState(expectedState), AssertFormatUtil.formatNames(elementNames), ProcessInstanceAssertj.formatState(expectedState), elementsNotInState);
            Assertions.fail((String)failureMessage);
        }
    }

    private static boolean isEnded(ProcessInstanceDto processInstance) {
        return processInstance != null && processInstance.getEndDate() != null;
    }

    private static boolean isEnded(FlowNodeInstanceDto flowNodeInstance) {
        return flowNodeInstance.getEndDate() != null;
    }

    private static String formatState(ProcessInstanceState state) {
        if (state == null) {
            return "not activated";
        }
        return state.name().toLowerCase();
    }

    private static String formatState(FlowNodeInstanceState state) {
        if (state == null) {
            return "not activated";
        }
        return state.name().toLowerCase();
    }
}

