/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.api;

import io.camunda.process.test.api.assertions.ProcessInstanceAssert;
import io.camunda.process.test.impl.assertions.CamundaDataSource;
import io.camunda.process.test.impl.assertions.ProcessInstanceAssertj;
import io.camunda.zeebe.client.api.response.ProcessInstanceEvent;
import io.camunda.zeebe.client.api.response.ProcessInstanceResult;
import java.time.Duration;
import org.awaitility.Awaitility;

public class CamundaAssert {
    public static final Duration DEFAULT_ASSERTION_TIMEOUT = Duration.ofSeconds(10L);
    public static final Duration DEFAULT_ASSERTION_INTERVAL = Duration.ofMillis(100L);
    private static final ThreadLocal<CamundaDataSource> DATA_SOURCE = new ThreadLocal();

    public static void setAssertionTimeout(Duration assertionTimeout) {
        Awaitility.setDefaultTimeout((Duration)assertionTimeout);
    }

    public static void setAssertionInterval(Duration assertionInterval) {
        Awaitility.setDefaultPollInterval((Duration)assertionInterval);
    }

    public static ProcessInstanceAssert assertThat(ProcessInstanceEvent processInstanceEvent) {
        return new ProcessInstanceAssertj(CamundaAssert.getDataSource(), processInstanceEvent.getProcessInstanceKey());
    }

    public static ProcessInstanceAssert assertThat(ProcessInstanceResult processInstanceResult) {
        return new ProcessInstanceAssertj(CamundaAssert.getDataSource(), processInstanceResult.getProcessInstanceKey());
    }

    private static CamundaDataSource getDataSource() {
        if (DATA_SOURCE.get() == null) {
            throw new IllegalStateException("No data source is set. Maybe you run outside of a testcase?");
        }
        return DATA_SOURCE.get();
    }

    static void initialize(CamundaDataSource dataSource) {
        DATA_SOURCE.set(dataSource);
    }

    static void reset() {
        DATA_SOURCE.remove();
    }

    static {
        Awaitility.setDefaultTimeout((Duration)DEFAULT_ASSERTION_TIMEOUT);
        Awaitility.setDefaultPollInterval((Duration)DEFAULT_ASSERTION_INTERVAL);
    }
}

