/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.assertions;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.process.test.impl.assertions.AssertFormatUtil;
import io.camunda.process.test.impl.assertions.CamundaDataSource;
import io.camunda.process.test.impl.client.VariableDto;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.awaitility.core.TerminalFailureException;

public class VariableAssertj
extends AbstractAssert<VariableAssertj, Long> {
    private final ObjectMapper jsonMapper = new ObjectMapper();
    private final CamundaDataSource dataSource;

    public VariableAssertj(CamundaDataSource dataSource, long processInstanceKey) {
        super((Object)processInstanceKey, VariableAssertj.class);
        this.dataSource = dataSource;
    }

    public VariableAssertj hasVariableNames(String ... variableNames) {
        AtomicReference reference = new AtomicReference(Collections.emptyMap());
        try {
            Awaitility.await().untilAsserted(() -> {
                Map<String, String> variables = this.getProcessInstanceVariables();
                reference.set(variables);
                Assertions.assertThat(variables).containsKeys((Object[])variableNames);
            });
        }
        catch (ConditionTimeoutException | TerminalFailureException e) {
            Map<String, String> actualVariables = reference.get();
            List<String> missingVariableNames = Arrays.stream(variableNames).filter(variableName -> !actualVariables.containsKey(variableName)).collect(Collectors.toList());
            String failureMessage = String.format("%s should have the variables %s but %s don't exist. All process instance variables:\n%s", AssertFormatUtil.formatProcessInstance((Long)this.actual), AssertFormatUtil.formatNames(variableNames), AssertFormatUtil.formatNames(missingVariableNames), VariableAssertj.formatVariables(actualVariables));
            Assertions.fail((String)failureMessage);
        }
        return this;
    }

    public VariableAssertj hasVariable(String variableName, Object variableValue) {
        JsonNode expectedValue = this.toJson(variableValue);
        AtomicReference reference = new AtomicReference(Collections.emptyMap());
        try {
            Awaitility.await().untilAsserted(() -> {
                Map<String, String> variables = this.getProcessInstanceVariables();
                reference.set(variables);
                Assertions.assertThat(variables).containsKey((Object)variableName);
                JsonNode actualValue = this.readJson(variables.get(variableName));
                Assertions.assertThat((Iterable)actualValue).isEqualTo((Object)expectedValue);
            });
        }
        catch (ConditionTimeoutException | TerminalFailureException e) {
            Map<String, String> actualVariables = reference.get();
            String failureReason = Optional.ofNullable((String)actualVariables.get(variableName)).map(value -> String.format("was '%s'", value)).orElse("the variable doesn't exist");
            String failureMessage = String.format("%s should have a variable '%s' with value '%s' but %s. All process instance variables:\n%s", AssertFormatUtil.formatProcessInstance((Long)this.actual), variableName, expectedValue, failureReason, VariableAssertj.formatVariables(actualVariables));
            Assertions.fail((String)failureMessage);
        }
        return this;
    }

    public VariableAssertj hasVariables(Map<String, Object> expectedVariables) {
        Map<String, JsonNode> expectedValues = expectedVariables.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.toJson(entry.getValue())));
        Set<String> expectedVariableNames = expectedVariables.keySet();
        AtomicReference reference = new AtomicReference(Collections.emptyMap());
        try {
            Awaitility.await().untilAsserted(() -> {
                Map<String, String> actualVariables = this.getProcessInstanceVariables();
                reference.set(actualVariables);
                Assertions.assertThat(actualVariables.keySet()).containsAll(expectedValues.keySet());
                Map<String, JsonNode> actualValues = actualVariables.entrySet().stream().filter(entry -> expectedVariableNames.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, entry -> this.readJson((String)entry.getValue())));
                Assertions.assertThat(actualValues).containsAllEntriesOf(expectedValues);
            });
        }
        catch (ConditionTimeoutException | TerminalFailureException e) {
            Map<String, String> actualVariables = reference.get();
            List<String> notMatchingVariableNames = expectedVariableNames.stream().filter(variableName -> !actualVariables.containsKey(variableName) || !this.readJson((String)actualVariables.get(variableName)).equals(expectedValues.get(variableName))).collect(Collectors.toList());
            String failureMessage = String.format("%s should have the variables %s but %s don't match. All process instance variables:\n%s", AssertFormatUtil.formatProcessInstance((Long)this.actual), this.toJson(expectedVariables), AssertFormatUtil.formatNames(notMatchingVariableNames), VariableAssertj.formatVariables(actualVariables));
            Assertions.fail((String)failureMessage);
        }
        return this;
    }

    private Map<String, String> getProcessInstanceVariables() throws IOException {
        return this.dataSource.getVariablesByProcessInstanceKey((Long)this.actual).stream().collect(Collectors.toMap(VariableDto::getName, VariableDto::getValue));
    }

    private static String formatVariables(Map<String, String> variables) {
        return variables.entrySet().stream().map(variable -> String.format("\t- '%s': %s", variable.getKey(), variable.getValue())).collect(Collectors.joining("\n"));
    }

    private JsonNode readJson(String value) {
        try {
            return (JsonNode)this.jsonMapper.readValue(value, JsonNode.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(String.format("Failed to read JSON: '%s'", value), e);
        }
    }

    private JsonNode toJson(Object value) {
        try {
            return (JsonNode)this.jsonMapper.convertValue(value, JsonNode.class);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(String.format("Failed to transform value to JSON: '%s'", value), e);
        }
    }
}

