/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.process.test.impl.client.CamundaClientNotFoundException;
import io.camunda.process.test.impl.client.FlowNodeInstancesResponseDto;
import io.camunda.process.test.impl.client.HttpClientUtil;
import io.camunda.process.test.impl.client.ProcessInstanceDto;
import io.camunda.process.test.impl.client.VariableResponseDto;
import java.io.IOException;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.entity.HttpEntities;

public class CamundaApiClient {
    private static final String LOGIN_ENDPOINT = "/api/login?username=%s&password=%s";
    private static final String LOGIN_USERNAME = "demo";
    private static final String LOGIN_PASSWORD = "demo";
    private static final String PROCESS_INSTANCE_GET_ENDPOINT = "/v1/process-instances/%d";
    private static final String FLOW_NODE_INSTANCES_SEARCH_ENDPOINT = "/v1/flownode-instances/search";
    private static final String VARIABLES_SEARCH_ENDPOINT = "/v1/variables/search";
    private final ObjectMapper objectMapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private boolean isLoggedIn = false;
    private final String restApiAddress;
    private final CloseableHttpClient httpClient;

    public CamundaApiClient(String restApiAddress) {
        this.restApiAddress = restApiAddress;
        BasicCookieStore cookieStore = new BasicCookieStore();
        this.httpClient = HttpClientBuilder.create().setDefaultCookieStore((CookieStore)cookieStore).build();
    }

    private void ensureAuthenticated() throws IOException {
        if (!this.isLoggedIn) {
            this.sendLoginRequest();
            this.isLoggedIn = true;
        }
    }

    private void sendLoginRequest() throws IOException {
        this.httpClient.execute((ClassicHttpRequest)new HttpPost(String.format(this.restApiAddress + LOGIN_ENDPOINT, "demo", "demo")), response -> {
            if (response.getCode() != 204) {
                throw new IllegalStateException(String.format("Failed to login. [code: %d, message: %s]", response.getCode(), HttpClientUtil.getReponseAsString(response)));
            }
            return null;
        });
    }

    private static void verifyStatusCode(ClassicHttpResponse response) {
        if (response.getCode() == 404) {
            throw new CamundaClientNotFoundException(String.format("Failed send request. Object not found. [code: %d, message: %s]", response.getCode(), HttpClientUtil.getReponseAsString(response)));
        }
        if (response.getCode() != 200) {
            throw new RuntimeException(String.format("Failed send request. [code: %d, message: %s]", response.getCode(), HttpClientUtil.getReponseAsString(response)));
        }
    }

    public ProcessInstanceDto getProcessInstanceByKey(long processInstanceKey) throws IOException {
        this.ensureAuthenticated();
        String body = this.sendGetRequest(String.format(PROCESS_INSTANCE_GET_ENDPOINT, processInstanceKey));
        return (ProcessInstanceDto)this.objectMapper.readValue(body, ProcessInstanceDto.class);
    }

    public FlowNodeInstancesResponseDto findFlowNodeInstancesByProcessInstanceKey(long processInstanceKey) throws IOException {
        this.ensureAuthenticated();
        String requestBody = String.format("{\"filter\": {\"processInstanceKey\":%d}}", processInstanceKey);
        String responseBody = this.sendPostRequest(FLOW_NODE_INSTANCES_SEARCH_ENDPOINT, requestBody);
        return (FlowNodeInstancesResponseDto)this.objectMapper.readValue(responseBody, FlowNodeInstancesResponseDto.class);
    }

    public VariableResponseDto findVariablesByProcessInstanceKey(long processInstanceKey) throws IOException {
        this.ensureAuthenticated();
        String requestBody = String.format("{\"filter\": {\"processInstanceKey\":%d, \"scopeKey\":%d}}", processInstanceKey, processInstanceKey);
        String responseBody = this.sendPostRequest(VARIABLES_SEARCH_ENDPOINT, requestBody);
        return (VariableResponseDto)this.objectMapper.readValue(responseBody, VariableResponseDto.class);
    }

    private String sendGetRequest(String endpoint) throws IOException {
        return (String)this.httpClient.execute((ClassicHttpRequest)new HttpGet(this.restApiAddress + endpoint), response -> {
            CamundaApiClient.verifyStatusCode(response);
            return HttpClientUtil.getReponseAsString(response);
        });
    }

    private String sendPostRequest(String endpoint, String body) throws IOException {
        HttpPost request = new HttpPost(this.restApiAddress + endpoint);
        request.setEntity(HttpEntities.create((String)body, (ContentType)ContentType.APPLICATION_JSON));
        return (String)this.httpClient.execute((ClassicHttpRequest)request, response -> {
            CamundaApiClient.verifyStatusCode(response);
            return HttpClientUtil.getReponseAsString(response);
        });
    }
}

