/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.process.test.impl.client.CamundaAddClockRequestDto;
import io.camunda.process.test.impl.client.CamundaClockResponseDto;
import io.camunda.process.test.impl.client.HttpClientUtil;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.entity.HttpEntities;

public class CamundaManagementClient {
    private static final String CLOCK_ENDPOINT = "/actuator/clock";
    private static final String CLOCK_ADD_ENDPOINT = "/actuator/clock/add";
    private final ObjectMapper objectMapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private final CloseableHttpClient httpClient = HttpClients.createDefault();
    private final URI camundaManagementApi;

    public CamundaManagementClient(URI camundaManagementApi) {
        this.camundaManagementApi = camundaManagementApi;
    }

    public Instant getCurrentTime() {
        try {
            HttpGet request = new HttpGet(this.camundaManagementApi + CLOCK_ENDPOINT);
            String responseBody = this.sendRequest((ClassicHttpRequest)request);
            CamundaClockResponseDto clockResponseDto = (CamundaClockResponseDto)this.objectMapper.readValue(responseBody, CamundaClockResponseDto.class);
            return Instant.parse(clockResponseDto.getInstant());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to resolve the current time", e);
        }
    }

    public void increaseTime(Duration timeToAdd) {
        HttpPost request = new HttpPost(this.camundaManagementApi + CLOCK_ADD_ENDPOINT);
        CamundaAddClockRequestDto requestDto = new CamundaAddClockRequestDto();
        requestDto.setOffsetMilli(timeToAdd.toMillis());
        try {
            String requestBody = this.objectMapper.writeValueAsString((Object)requestDto);
            request.setEntity(HttpEntities.create((String)requestBody, (ContentType)ContentType.APPLICATION_JSON));
            this.sendRequest((ClassicHttpRequest)request);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to increase the time", e);
        }
    }

    private String sendRequest(ClassicHttpRequest request) throws IOException {
        return (String)this.httpClient.execute(request, response -> {
            if (response.getCode() != 200) {
                throw new RuntimeException(String.format("Request failed. [code: %d, message: %s]", response.getCode(), HttpClientUtil.getReponseAsString(response)));
            }
            return HttpClientUtil.getReponseAsString(response);
        });
    }
}

