/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.containers;

import java.net.URI;
import java.time.Duration;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class CamundaContainer
extends GenericContainer<CamundaContainer> {
    private static final Duration DEFAULT_STARTUP_TIMEOUT = Duration.ofMinutes(1L);
    private static final String READY_ENDPOINT = "/ready";
    private static final String ACTIVE_SPRING_PROFILES = "operate,tasklist,broker,dev,dev-data,auth";
    private static final String GRPC_API = "localhost:26500";
    private static final String REST_API = "localhost:8080";
    private static final String ELASTICSEARCH_EXPORTER_CLASSNAME = "io.camunda.zeebe.exporter.ElasticsearchExporter";
    private static final String ELASTICSEARCH_BULK_SIZE = "1";
    private static final String IMPORTER_READER_BACKOFF = "1000";

    public CamundaContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        this.applyDefaultConfiguration();
    }

    private void applyDefaultConfiguration() {
        ((CamundaContainer)((CamundaContainer)((CamundaContainer)((CamundaContainer)((CamundaContainer)((CamundaContainer)((CamundaContainer)((CamundaContainer)((CamundaContainer)((CamundaContainer)((CamundaContainer)this.withNetwork(Network.SHARED)).waitingFor((WaitStrategy)this.newDefaultWaitStrategy())).withEnv("SPRING_PROFILES_ACTIVE", ACTIVE_SPRING_PROFILES)).withEnv("ZEEBE_CLOCK_CONTROLLED", "true")).withEnv("CAMUNDA_OPERATE_ZEEBE_GATEWAYADDRESS", GRPC_API)).withEnv("CAMUNDA_OPERATE_CSRF_PREVENTION_ENABLED", "false")).withEnv("CAMUNDA_OPERATE_IMPORTER_READERBACKOFF", IMPORTER_READER_BACKOFF)).withEnv("CAMUNDA_TASKLIST_ZEEBE_GATEWAYADDRESS", GRPC_API)).withEnv("CAMUNDA_TASKLIST_ZEEBE_RESTADDRESS", REST_API)).withEnv("CAMUNDA_TASKLIST_CSRFPREVENTIONENABLED", "false")).withEnv("CAMUNDA_TASKLIST_IMPORTER_READERBACKOFF", IMPORTER_READER_BACKOFF)).addExposedPorts(new int[]{26500, 26501, 26502, 9600, 8080});
    }

    public CamundaContainer withElasticsearchUrl(String url) {
        this.withEnv("ZEEBE_BROKER_EXPORTERS_ELASTICSEARCH_CLASSNAME", ELASTICSEARCH_EXPORTER_CLASSNAME);
        this.withEnv("ZEEBE_BROKER_EXPORTERS_ELASTICSEARCH_ARGS_URL", url);
        this.withEnv("ZEEBE_BROKER_EXPORTERS_ELASTICSEARCH_ARGS_BULK_SIZE", ELASTICSEARCH_BULK_SIZE);
        this.withEnv("CAMUNDA_OPERATE_ELASTICSEARCH_URL", url);
        this.withEnv("CAMUNDA_OPERATE_ZEEBEELASTICSEARCH_URL", url);
        this.withEnv("CAMUNDA_TASKLIST_ELASTICSEARCH_URL", url);
        this.withEnv("CAMUNDA_TASKLIST_ZEEBEELASTICSEARCH_URL", url);
        return this;
    }

    public static HttpWaitStrategy newDefaultBrokerReadyCheck() {
        return new HttpWaitStrategy().forPath(READY_ENDPOINT).forPort(9600).forStatusCodeMatching(status -> status >= 200 && status < 300).withReadTimeout(Duration.ofSeconds(10L));
    }

    private WaitAllStrategy newDefaultWaitStrategy() {
        return new WaitAllStrategy(WaitAllStrategy.Mode.WITH_OUTER_TIMEOUT).withStrategy((WaitStrategy)new HostPortWaitStrategy()).withStrategy((WaitStrategy)CamundaContainer.newDefaultBrokerReadyCheck()).withStartupTimeout(DEFAULT_STARTUP_TIMEOUT);
    }

    public int getGrpcApiPort() {
        return this.getMappedPort(26500);
    }

    public int getRestApiPort() {
        return this.getMappedPort(8080);
    }

    public URI getGrpcApiAddress() {
        return this.toUriWithPort(this.getGrpcApiPort());
    }

    public URI getRestApiAddress() {
        return this.toUriWithPort(this.getRestApiPort());
    }

    private URI toUriWithPort(int port) {
        return URI.create("http://" + this.getHost() + ":" + port);
    }

    public URI getMonitoringApiAddress() {
        return this.toUriWithPort(this.getMonitoringApiPort());
    }

    public int getMonitoringApiPort() {
        return this.getMappedPort(9600);
    }
}

