/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.runtime;

import io.camunda.process.test.impl.containers.ContainerFactory;
import io.camunda.process.test.impl.runtime.CamundaContainerRuntime;
import io.camunda.process.test.impl.runtime.ContainerRuntimeDefaults;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CamundaContainerRuntimeBuilder {
    private ContainerFactory containerFactory = new ContainerFactory();
    private String camundaDockerImageName = "camunda/camunda";
    private String camundaDockerImageVersion = ContainerRuntimeDefaults.CAMUNDA_DOCKER_IMAGE_VERSION;
    private String elasticsearchDockerImageName = "elasticsearch";
    private String elasticsearchDockerImageVersion = ContainerRuntimeDefaults.ELASTICSEARCH_DOCKER_IMAGE_VERSION;
    private String connectorsDockerImageName = "camunda/connectors-bundle";
    private String connectorsDockerImageVersion = ContainerRuntimeDefaults.CONNECTORS_DOCKER_IMAGE_VERSION;
    private final Map<String, String> camundaEnvVars = new HashMap<String, String>();
    private final Map<String, String> elasticsearchEnvVars = new HashMap<String, String>();
    private final Map<String, String> connectorsEnvVars = new HashMap<String, String>();
    private final List<Integer> camundaExposedPorts = new ArrayList<Integer>();
    private final List<Integer> elasticsearchExposedPorts = new ArrayList<Integer>();
    private final List<Integer> connectorsExposedPorts = new ArrayList<Integer>();
    private String camundaLoggerName = "tc.camunda";
    private String elasticsearchLoggerName = "tc.elasticsearch";
    private String connectorsLoggerName = "tc.connectors";
    private boolean connectorsEnabled = false;
    private final Map<String, String> connectorsSecrets = new HashMap<String, String>();

    CamundaContainerRuntimeBuilder withContainerFactory(ContainerFactory containerFactory) {
        this.containerFactory = containerFactory;
        return this;
    }

    public CamundaContainerRuntimeBuilder withCamundaDockerImageName(String dockerImageName) {
        this.camundaDockerImageName = dockerImageName;
        return this;
    }

    public CamundaContainerRuntimeBuilder withCamundaDockerImageVersion(String dockerImageVersion) {
        this.camundaDockerImageVersion = dockerImageVersion;
        return this;
    }

    public CamundaContainerRuntimeBuilder withElasticsearchDockerImageName(String dockerImageName) {
        this.elasticsearchDockerImageName = dockerImageName;
        return this;
    }

    public CamundaContainerRuntimeBuilder withElasticsearchDockerImageVersion(String dockerImageVersion) {
        this.elasticsearchDockerImageVersion = dockerImageVersion;
        return this;
    }

    public CamundaContainerRuntimeBuilder withConnectorsDockerImageName(String dockerImageName) {
        this.connectorsDockerImageName = dockerImageName;
        return this;
    }

    public CamundaContainerRuntimeBuilder withConnectorsDockerImageVersion(String dockerImageVersion) {
        this.connectorsDockerImageVersion = dockerImageVersion;
        return this;
    }

    public CamundaContainerRuntimeBuilder withCamundaEnv(Map<String, String> envVars) {
        this.camundaEnvVars.putAll(envVars);
        return this;
    }

    public CamundaContainerRuntimeBuilder withCamundaEnv(String name, String value) {
        this.camundaEnvVars.put(name, value);
        return this;
    }

    public CamundaContainerRuntimeBuilder withElasticsearchEnv(Map<String, String> envVars) {
        this.elasticsearchEnvVars.putAll(envVars);
        return this;
    }

    public CamundaContainerRuntimeBuilder withElasticsearchEnv(String name, String value) {
        this.elasticsearchEnvVars.put(name, value);
        return this;
    }

    public CamundaContainerRuntimeBuilder withConnectorsEnv(Map<String, String> envVars) {
        this.connectorsEnvVars.putAll(envVars);
        return this;
    }

    public CamundaContainerRuntimeBuilder withConnectorsEnv(String name, String value) {
        this.connectorsEnvVars.put(name, value);
        return this;
    }

    public CamundaContainerRuntimeBuilder withCamundaExposedPort(int port) {
        this.camundaExposedPorts.add(port);
        return this;
    }

    public CamundaContainerRuntimeBuilder withElasticsearchExposedPort(int port) {
        this.elasticsearchExposedPorts.add(port);
        return this;
    }

    public CamundaContainerRuntimeBuilder withConnectorsExposedPort(int port) {
        this.connectorsExposedPorts.add(port);
        return this;
    }

    public CamundaContainerRuntimeBuilder withCamundaLogger(String loggerName) {
        this.camundaLoggerName = loggerName;
        return this;
    }

    public CamundaContainerRuntimeBuilder withElasticsearchLogger(String loggerName) {
        this.elasticsearchLoggerName = loggerName;
        return this;
    }

    public CamundaContainerRuntimeBuilder withConnectorsLogger(String loggerName) {
        this.connectorsLoggerName = loggerName;
        return this;
    }

    public CamundaContainerRuntimeBuilder withConnectorsEnabled(boolean enabled) {
        this.connectorsEnabled = enabled;
        return this;
    }

    public CamundaContainerRuntimeBuilder withConnectorsSecret(String name, String value) {
        this.connectorsSecrets.put(name, value);
        return this;
    }

    public CamundaContainerRuntimeBuilder withConnectorsSecrets(Map<String, String> secrets) {
        this.connectorsSecrets.putAll(secrets);
        return this;
    }

    public CamundaContainerRuntime build() {
        return new CamundaContainerRuntime(this, this.containerFactory);
    }

    public String getCamundaDockerImageName() {
        return this.camundaDockerImageName;
    }

    public String getCamundaDockerImageVersion() {
        return this.camundaDockerImageVersion;
    }

    public String getElasticsearchDockerImageName() {
        return this.elasticsearchDockerImageName;
    }

    public String getElasticsearchDockerImageVersion() {
        return this.elasticsearchDockerImageVersion;
    }

    public String getConnectorsDockerImageName() {
        return this.connectorsDockerImageName;
    }

    public String getConnectorsDockerImageVersion() {
        return this.connectorsDockerImageVersion;
    }

    public Map<String, String> getCamundaEnvVars() {
        return this.camundaEnvVars;
    }

    public Map<String, String> getElasticsearchEnvVars() {
        return this.elasticsearchEnvVars;
    }

    public Map<String, String> getConnectorsEnvVars() {
        return this.connectorsEnvVars;
    }

    public List<Integer> getCamundaExposedPorts() {
        return this.camundaExposedPorts;
    }

    public List<Integer> getElasticsearchExposedPorts() {
        return this.elasticsearchExposedPorts;
    }

    public List<Integer> getConnectorsExposedPorts() {
        return this.connectorsExposedPorts;
    }

    public String getCamundaLoggerName() {
        return this.camundaLoggerName;
    }

    public String getElasticsearchLoggerName() {
        return this.elasticsearchLoggerName;
    }

    public String getConnectorsLoggerName() {
        return this.connectorsLoggerName;
    }

    public boolean isConnectorsEnabled() {
        return this.connectorsEnabled;
    }

    public Map<String, String> getConnectorsSecrets() {
        return this.connectorsSecrets;
    }
}

