/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContainerRuntimeVersionUtil {
    public static final Logger LOGGER = LoggerFactory.getLogger(ContainerRuntimeVersionUtil.class);
    public static final String VERSION_PROPERTIES_FILE = "/camunda-container-runtime.properties";
    public static final String PROPERTY_NAME_CAMUNDA_VERSION = "camunda.version";
    public static final String PROPERTY_NAME_ELASTICSEARCH_VERSION = "elasticsearch.version";
    public static final String CAMUNDA_VERSION_SNAPSHOT = "SNAPSHOT";
    public static final String ELASTICSEARCH_VERSION_DEFAULT = "8.13.0";
    private static final Pattern SEMANTIC_VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(-.*)?");
    private static final String VERSION_FORMAT = "%d.%d.%d";
    private final String camundaVersion;
    private final String elasticsearchVersion;

    public ContainerRuntimeVersionUtil(Properties versionProperties) {
        this.camundaVersion = ContainerRuntimeVersionUtil.resolveCamundaVersion(versionProperties);
        this.elasticsearchVersion = this.resolveElasticsearchVersion(versionProperties);
    }

    private static String resolveCamundaVersion(Properties versionProperties) {
        return Optional.ofNullable(versionProperties.getProperty(PROPERTY_NAME_CAMUNDA_VERSION)).map(SEMANTIC_VERSION_PATTERN::matcher).filter(Matcher::find).map(matcher -> {
            int major = Integer.parseInt(matcher.group(1));
            int minor = Integer.parseInt(matcher.group(2));
            int patch = Integer.parseInt(matcher.group(3));
            String label = matcher.group(4);
            return ContainerRuntimeVersionUtil.resolveCamundaVersion(major, minor, patch, label);
        }).orElse(CAMUNDA_VERSION_SNAPSHOT);
    }

    private static String resolveCamundaVersion(int major, int minor, int patch, String label) {
        if (label == null) {
            return String.format(VERSION_FORMAT, major, minor, patch);
        }
        if (patch == 0) {
            return CAMUNDA_VERSION_SNAPSHOT;
        }
        int previousPatchVersion = patch - 1;
        return String.format(VERSION_FORMAT, major, minor, previousPatchVersion);
    }

    private String resolveElasticsearchVersion(Properties versionProperties) {
        return Optional.ofNullable(versionProperties.getProperty(PROPERTY_NAME_ELASTICSEARCH_VERSION)).filter(version -> SEMANTIC_VERSION_PATTERN.matcher((CharSequence)version).find()).orElse(ELASTICSEARCH_VERSION_DEFAULT);
    }

    public static ContainerRuntimeVersionUtil readVersions() {
        return new ContainerRuntimeVersionUtil(ContainerRuntimeVersionUtil.readVersionFile());
    }

    private static Properties readVersionFile() {
        Properties properties;
        block8: {
            InputStream versionFileStream = ContainerRuntimeVersionUtil.class.getResourceAsStream(VERSION_PROPERTIES_FILE);
            try {
                Properties properties2 = new Properties();
                properties2.load(versionFileStream);
                properties = properties2;
                if (versionFileStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (versionFileStream != null) {
                        try {
                            versionFileStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.warn(String.format("Can't read version file: %s", VERSION_PROPERTIES_FILE), (Throwable)e);
                    return new Properties();
                }
            }
            versionFileStream.close();
        }
        return properties;
    }

    public String getCamundaVersion() {
        return this.camundaVersion;
    }

    public String getElasticsearchVersion() {
        return this.elasticsearchVersion;
    }
}

