/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.api;

import io.camunda.client.api.response.EvaluateDecisionResponse;
import io.camunda.client.api.response.ProcessInstanceResult;
import io.camunda.process.test.api.assertions.DecisionInstanceAssert;
import io.camunda.process.test.api.assertions.DecisionSelector;
import io.camunda.process.test.api.assertions.DecisionSelectors;
import io.camunda.process.test.api.assertions.ElementSelector;
import io.camunda.process.test.api.assertions.ElementSelectors;
import io.camunda.process.test.api.assertions.ProcessInstanceAssert;
import io.camunda.process.test.api.assertions.ProcessInstanceSelector;
import io.camunda.process.test.api.assertions.UserTaskAssert;
import io.camunda.process.test.api.assertions.UserTaskSelector;
import io.camunda.process.test.impl.assertions.CamundaDataSource;
import io.camunda.process.test.impl.assertions.DecisionInstanceAssertj;
import io.camunda.process.test.impl.assertions.ProcessInstanceAssertj;
import io.camunda.process.test.impl.assertions.UserTaskAssertj;
import io.camunda.zeebe.client.api.response.ProcessInstanceEvent;
import java.time.Duration;
import java.util.function.Function;
import org.awaitility.Awaitility;

public class CamundaAssert {
    public static final Duration DEFAULT_ASSERTION_TIMEOUT = Duration.ofSeconds(10L);
    public static final Duration DEFAULT_ASSERTION_INTERVAL = Duration.ofMillis(100L);
    public static final Function<String, ElementSelector> DEFAULT_ELEMENT_SELECTOR = ElementSelectors::byId;
    private static final ThreadLocal<CamundaDataSource> DATA_SOURCE = new ThreadLocal();
    private static Function<String, ElementSelector> elementSelector = DEFAULT_ELEMENT_SELECTOR;

    public static void setAssertionTimeout(Duration assertionTimeout) {
        Awaitility.setDefaultTimeout((Duration)assertionTimeout);
    }

    public static void setAssertionInterval(Duration assertionInterval) {
        Awaitility.setDefaultPollInterval((Duration)assertionInterval);
    }

    public static void setElementSelector(Function<String, ElementSelector> elementSelector) {
        CamundaAssert.elementSelector = elementSelector;
    }

    public static ProcessInstanceAssert assertThat(io.camunda.client.api.response.ProcessInstanceEvent processInstanceEvent) {
        return CamundaAssert.createProcessInstanceAssertj(processInstanceEvent.getProcessInstanceKey());
    }

    @Deprecated
    public static ProcessInstanceAssert assertThat(ProcessInstanceEvent processInstanceEvent) {
        return CamundaAssert.createProcessInstanceAssertj(processInstanceEvent.getProcessInstanceKey());
    }

    public static ProcessInstanceAssert assertThat(ProcessInstanceResult processInstanceResult) {
        return CamundaAssert.createProcessInstanceAssertj(processInstanceResult.getProcessInstanceKey());
    }

    @Deprecated
    public static ProcessInstanceAssert assertThat(io.camunda.zeebe.client.api.response.ProcessInstanceResult processInstanceResult) {
        return CamundaAssert.createProcessInstanceAssertj(processInstanceResult.getProcessInstanceKey());
    }

    private static ProcessInstanceAssertj createProcessInstanceAssertj(long processInstanceKey) {
        return new ProcessInstanceAssertj(CamundaAssert.getDataSource(), processInstanceKey, elementSelector);
    }

    public static ProcessInstanceAssert assertThat(ProcessInstanceSelector processInstanceSelector) {
        return new ProcessInstanceAssertj(CamundaAssert.getDataSource(), processInstanceSelector, elementSelector);
    }

    public static UserTaskAssert assertThat(UserTaskSelector userTaskSelector) {
        return new UserTaskAssertj(CamundaAssert.getDataSource(), userTaskSelector);
    }

    public static DecisionInstanceAssert assertThat(DecisionSelector decisionSelector) {
        return new DecisionInstanceAssertj(CamundaAssert.getDataSource(), decisionSelector);
    }

    public static DecisionInstanceAssertj assertThat(EvaluateDecisionResponse response) {
        return new DecisionInstanceAssertj(CamundaAssert.getDataSource(), DecisionSelectors.byResponse(response));
    }

    private static CamundaDataSource getDataSource() {
        if (DATA_SOURCE.get() == null) {
            throw new IllegalStateException("No data source is set. Maybe you run outside of a testcase?");
        }
        return DATA_SOURCE.get();
    }

    static void initialize(CamundaDataSource dataSource) {
        DATA_SOURCE.set(dataSource);
    }

    static void reset() {
        DATA_SOURCE.remove();
    }

    static {
        Awaitility.setDefaultTimeout((Duration)DEFAULT_ASSERTION_TIMEOUT);
        Awaitility.setDefaultPollInterval((Duration)DEFAULT_ASSERTION_INTERVAL);
    }
}

