/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.api.assertions;

import io.camunda.client.api.search.filter.UserTaskFilter;
import io.camunda.client.api.search.response.UserTask;
import io.camunda.process.test.api.assertions.UserTaskSelector;

public class UserTaskSelectors {
    public static UserTaskSelector byElementId(String elementId) {
        return new UserTaskElementIdSelector(elementId);
    }

    public static UserTaskSelector byElementId(String elementId, long processInstanceKey) {
        return new UserTaskElementIdSelector(elementId, processInstanceKey);
    }

    public static UserTaskSelector byTaskName(String taskName) {
        return new UserTaskNameSelector(taskName);
    }

    public static UserTaskSelector byTaskName(String taskName, long processInstanceKey) {
        return new UserTaskNameSelector(taskName, processInstanceKey);
    }

    private static final class UserTaskElementIdSelector
    implements UserTaskSelector {
        private final String elementId;
        private final Long processInstanceKey;

        private UserTaskElementIdSelector(String elementId) {
            this(elementId, (Long)null);
        }

        private UserTaskElementIdSelector(String elementId, Long processInstanceKey) {
            this.elementId = elementId;
            this.processInstanceKey = processInstanceKey;
        }

        @Override
        public boolean test(UserTask userTask) {
            return this.elementId.equals(userTask.getElementId());
        }

        @Override
        public String describe() {
            if (this.processInstanceKey != null) {
                return String.format("%s (processInstanceKey: %d)", this.elementId, this.processInstanceKey);
            }
            return this.elementId;
        }

        @Override
        public void applyFilter(UserTaskFilter filter) {
            filter.elementId(this.elementId);
            if (this.processInstanceKey != null) {
                filter.processInstanceKey(this.processInstanceKey);
            }
        }
    }

    private static final class UserTaskNameSelector
    implements UserTaskSelector {
        private final String taskName;
        private final Long processInstanceKey;

        private UserTaskNameSelector(String taskName) {
            this(taskName, (Long)null);
        }

        private UserTaskNameSelector(String taskName, Long processInstanceKey) {
            this.taskName = taskName;
            this.processInstanceKey = processInstanceKey;
        }

        @Override
        public boolean test(UserTask userTask) {
            return this.taskName.equals(userTask.getName());
        }

        @Override
        public String describe() {
            if (this.processInstanceKey != null) {
                return String.format("%s (processInstanceKey: %d)", this.taskName, this.processInstanceKey);
            }
            return this.taskName;
        }

        @Override
        public void applyFilter(UserTaskFilter filter) {
            if (this.processInstanceKey != null) {
                filter.processInstanceKey(this.processInstanceKey);
            }
        }
    }
}

