/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.assertions;

import io.camunda.client.CamundaClient;
import io.camunda.client.api.search.filter.DecisionInstanceFilter;
import io.camunda.client.api.search.filter.ElementInstanceFilter;
import io.camunda.client.api.search.filter.IncidentFilter;
import io.camunda.client.api.search.filter.ProcessInstanceFilter;
import io.camunda.client.api.search.filter.UserTaskFilter;
import io.camunda.client.api.search.filter.VariableFilter;
import io.camunda.client.api.search.request.DecisionInstanceSearchRequest;
import io.camunda.client.api.search.request.ElementInstanceSearchRequest;
import io.camunda.client.api.search.request.IncidentSearchRequest;
import io.camunda.client.api.search.request.ProcessInstanceSearchRequest;
import io.camunda.client.api.search.request.SearchRequestPage;
import io.camunda.client.api.search.request.UserTaskSearchRequest;
import io.camunda.client.api.search.request.VariableSearchRequest;
import io.camunda.client.api.search.response.DecisionInstance;
import io.camunda.client.api.search.response.ElementInstance;
import io.camunda.client.api.search.response.Incident;
import io.camunda.client.api.search.response.ProcessInstance;
import io.camunda.client.api.search.response.SearchResponse;
import io.camunda.client.api.search.response.UserTask;
import io.camunda.client.api.search.response.Variable;
import java.util.List;
import java.util.function.Consumer;

public class CamundaDataSource {
    private static final Consumer<SearchRequestPage> DEFAULT_PAGE_REQUEST = page -> page.limit(Integer.valueOf(100));
    private final CamundaClient client;

    public CamundaDataSource(CamundaClient client) {
        this.client = client;
    }

    public List<ElementInstance> findElementInstancesByProcessInstanceKey(long processInstanceKey) {
        return this.findElementInstances(filter -> filter.processInstanceKey(processInstanceKey));
    }

    public List<ElementInstance> findElementInstances(Consumer<ElementInstanceFilter> filter) {
        return ((SearchResponse)((ElementInstanceSearchRequest)((ElementInstanceSearchRequest)((ElementInstanceSearchRequest)this.client.newElementInstanceSearchRequest().filter(filter)).sort(sort -> sort.startDate().asc())).page(DEFAULT_PAGE_REQUEST)).send().join()).items();
    }

    public List<Variable> findGlobalVariablesByProcessInstanceKey(long processInstanceKey) {
        return this.findVariables(filter -> filter.processInstanceKey(Long.valueOf(processInstanceKey)).scopeKey(Long.valueOf(processInstanceKey)));
    }

    public List<Variable> findVariables(Consumer<VariableFilter> filter) {
        return ((SearchResponse)((VariableSearchRequest)((VariableSearchRequest)this.client.newVariableSearchRequest().filter(filter)).page(DEFAULT_PAGE_REQUEST)).send().join()).items();
    }

    public List<ProcessInstance> findProcessInstances() {
        return this.findProcessInstances(filter -> {});
    }

    public List<ProcessInstance> findProcessInstances(Consumer<ProcessInstanceFilter> filter) {
        return ((SearchResponse)((ProcessInstanceSearchRequest)((ProcessInstanceSearchRequest)((ProcessInstanceSearchRequest)this.client.newProcessInstanceSearchRequest().filter(filter)).sort(sort -> sort.startDate().asc())).page(DEFAULT_PAGE_REQUEST)).send().join()).items();
    }

    public List<Incident> findIncidents(Consumer<IncidentFilter> filter) {
        return ((SearchResponse)((IncidentSearchRequest)((IncidentSearchRequest)((IncidentSearchRequest)this.client.newIncidentSearchRequest().filter(filter)).sort(sort -> sort.creationTime().asc())).page(DEFAULT_PAGE_REQUEST)).send().join()).items();
    }

    public List<UserTask> findUserTasks(Consumer<UserTaskFilter> filter) {
        return ((SearchResponse)((UserTaskSearchRequest)((UserTaskSearchRequest)((UserTaskSearchRequest)this.client.newUserTaskSearchRequest().filter(filter)).sort(sort -> sort.creationDate().asc())).page(DEFAULT_PAGE_REQUEST)).send().join()).items();
    }

    public List<DecisionInstance> findDecisionInstances(Consumer<DecisionInstanceFilter> filter) {
        return ((SearchResponse)((DecisionInstanceSearchRequest)this.client.newDecisionInstanceSearchRequest().filter(filter)).send().join()).items();
    }

    public DecisionInstance getDecisionInstance(String decisionInstanceId) {
        return (DecisionInstance)this.client.newDecisionInstanceGetRequest(decisionInstanceId).send().join();
    }
}

