/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.assertions;

import io.camunda.client.api.command.ClientException;
import io.camunda.client.api.search.response.DecisionInstance;
import io.camunda.client.api.search.response.DecisionInstanceState;
import io.camunda.process.test.api.assertions.DecisionInstanceAssert;
import io.camunda.process.test.api.assertions.DecisionSelector;
import io.camunda.process.test.impl.assertions.CamundaDataSource;
import io.camunda.process.test.impl.assertions.DecisionMatchedRulesAssertj;
import io.camunda.process.test.impl.assertions.DecisionOutputAssertj;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;

public class DecisionInstanceAssertj
extends AbstractAssert<DecisionInstanceAssertj, DecisionSelector>
implements DecisionInstanceAssert {
    private final CamundaDataSource dataSource;
    private final DecisionMatchedRulesAssertj decisionMatchedRulesAssertj;
    private final DecisionOutputAssertj decisionOutputAssertj;

    public DecisionInstanceAssertj(CamundaDataSource dataSource, DecisionSelector decisionSelector) {
        super((Object)decisionSelector, DecisionInstanceAssert.class);
        String failureMessagePrefix = String.format("Expected DecisionInstance [%s]", ((DecisionSelector)this.actual).describe());
        this.dataSource = dataSource;
        this.decisionMatchedRulesAssertj = new DecisionMatchedRulesAssertj(failureMessagePrefix);
        this.decisionOutputAssertj = new DecisionOutputAssertj(failureMessagePrefix);
    }

    @Override
    public DecisionInstanceAssert isEvaluated() {
        this.awaitDecisionInstance(instance -> ((AbstractComparableAssert)Assertions.assertThat((Comparable)instance.getState()).withFailMessage("Expected DecisionInstance [%s] to have been evaluated, but was %s", new Object[]{((DecisionSelector)this.actual).describe(), this.formatState(instance.getState())})).isEqualTo((Object)DecisionInstanceState.EVALUATED));
        return this;
    }

    @Override
    public DecisionInstanceAssert hasOutput(Object expectedOutput) {
        this.awaitDecisionInstance(instance -> this.decisionOutputAssertj.hasOutput(instance.getResult(), expectedOutput));
        return this;
    }

    @Override
    public DecisionInstanceAssert hasNoMatchedRules() {
        this.awaitDecisionInstance(instance -> this.decisionMatchedRulesAssertj.hasNoMatchedRules(instance.getMatchedRules()));
        return this;
    }

    @Override
    public DecisionInstanceAssert hasMatchedRules(int ... expectedMatchedRuleIndexes) {
        this.awaitDecisionInstance(instance -> this.decisionMatchedRulesAssertj.hasMatchedRules(instance.getMatchedRules(), expectedMatchedRuleIndexes));
        return this;
    }

    @Override
    public DecisionInstanceAssert hasNotMatchedRules(int ... expectedUnmatchedRuleIndexes) {
        this.awaitDecisionInstance(instance -> this.decisionMatchedRulesAssertj.hasNotMatchedRules(instance.getMatchedRules(), expectedUnmatchedRuleIndexes));
        return this;
    }

    private String formatState(DecisionInstanceState state) {
        if (state == null) {
            return "not activated";
        }
        return state.name().toLowerCase();
    }

    private void awaitDecisionInstance(Consumer<DecisionInstance> assertion) {
        AtomicReference<String> failureMessage = new AtomicReference<String>("?");
        try {
            Awaitility.await().ignoreException(ClientException.class).untilAsserted(() -> this.dataSource.findDecisionInstances(((DecisionSelector)this.actual)::applyFilter), decisionInstances -> {
                Optional<DecisionInstance> discoveredDecisionInstance = decisionInstances.stream().filter(((DecisionSelector)this.actual)::test).findFirst();
                try {
                    ((OptionalAssert)Assertions.assertThat(discoveredDecisionInstance).withFailMessage("No DecisionInstance [%s] found.", new Object[]{((DecisionSelector)this.actual).describe()})).isPresent();
                    DecisionInstance completeDecisionInstance = this.dataSource.getDecisionInstance(discoveredDecisionInstance.get().getDecisionInstanceId());
                    assertion.accept(completeDecisionInstance);
                }
                catch (AssertionError e) {
                    failureMessage.set(((Throwable)((Object)e)).getMessage());
                    throw e;
                }
            });
        }
        catch (ConditionTimeoutException ignore) {
            Assertions.fail((String)failureMessage.get());
        }
    }
}

