/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.assertions;

import io.camunda.client.api.command.ClientException;
import io.camunda.client.api.search.enums.ProcessInstanceState;
import io.camunda.client.api.search.response.ProcessInstance;
import io.camunda.process.test.api.assertions.ElementSelector;
import io.camunda.process.test.api.assertions.ProcessInstanceAssert;
import io.camunda.process.test.api.assertions.ProcessInstanceSelector;
import io.camunda.process.test.api.assertions.ProcessInstanceSelectors;
import io.camunda.process.test.impl.assertions.CamundaDataSource;
import io.camunda.process.test.impl.assertions.ElementAssertj;
import io.camunda.process.test.impl.assertions.IncidentAssertj;
import io.camunda.process.test.impl.assertions.VariableAssertj;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.awaitility.core.TerminalFailureException;

public class ProcessInstanceAssertj
extends AbstractAssert<ProcessInstanceAssertj, ProcessInstanceSelector>
implements ProcessInstanceAssert {
    private final CamundaDataSource dataSource;
    private final ElementAssertj elementAssertj;
    private final VariableAssertj variableAssertj;
    private final IncidentAssertj incidentAssertj;
    private final String failureMessagePrefix;
    private final Function<String, ElementSelector> elementSelector;
    private final AtomicReference<ProcessInstance> actualProcessInstance = new AtomicReference();

    public ProcessInstanceAssertj(CamundaDataSource dataSource, long processInstanceKey, Function<String, ElementSelector> elementSelector) {
        this(dataSource, ProcessInstanceSelectors.byKey(processInstanceKey), elementSelector);
    }

    public ProcessInstanceAssertj(CamundaDataSource dataSource, ProcessInstanceSelector processInstanceSelector, Function<String, ElementSelector> elementSelector) {
        super((Object)processInstanceSelector, ProcessInstanceAssertj.class);
        this.dataSource = dataSource;
        this.failureMessagePrefix = String.format("Process instance [%s]", processInstanceSelector.describe());
        this.elementSelector = elementSelector;
        this.elementAssertj = new ElementAssertj(dataSource, this.failureMessagePrefix);
        this.variableAssertj = new VariableAssertj(dataSource, this.failureMessagePrefix);
        this.incidentAssertj = new IncidentAssertj(dataSource, this.failureMessagePrefix);
    }

    @Override
    public ProcessInstanceAssert isActive() {
        this.hasProcessInstanceInState("active", arg_0 -> ProcessInstanceState.ACTIVE.equals(arg_0), Objects::nonNull);
        return this;
    }

    @Override
    public ProcessInstanceAssert isCompleted() {
        this.hasProcessInstanceInState("completed", arg_0 -> ProcessInstanceState.COMPLETED.equals(arg_0), ProcessInstanceAssertj::isEnded);
        return this;
    }

    @Override
    public ProcessInstanceAssert isTerminated() {
        this.hasProcessInstanceInState("terminated", arg_0 -> ProcessInstanceState.TERMINATED.equals(arg_0), ProcessInstanceAssertj::isEnded);
        return this;
    }

    @Override
    public ProcessInstanceAssert isCreated() {
        this.hasProcessInstanceInState("created", state -> state == ProcessInstanceState.ACTIVE || state == ProcessInstanceState.COMPLETED || state == ProcessInstanceState.TERMINATED, Objects::nonNull);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasActiveElements(String ... elementIds) {
        this.elementAssertj.hasActiveElements(this.getProcessInstanceKey(), this.toElementSelectors(elementIds));
        return this;
    }

    @Override
    public ProcessInstanceAssert hasActiveElements(ElementSelector ... elementSelectors) {
        this.elementAssertj.hasActiveElements(this.getProcessInstanceKey(), Arrays.asList(elementSelectors));
        return this;
    }

    @Override
    public ProcessInstanceAssert hasCompletedElements(String ... elementIds) {
        this.elementAssertj.hasCompletedElements(this.getProcessInstanceKey(), this.toElementSelectors(elementIds));
        return this;
    }

    @Override
    public ProcessInstanceAssert hasCompletedElements(ElementSelector ... elementSelectors) {
        this.elementAssertj.hasCompletedElements(this.getProcessInstanceKey(), Arrays.asList(elementSelectors));
        return this;
    }

    @Override
    public ProcessInstanceAssert hasCompletedElementsInOrder(String ... elementIds) {
        this.elementAssertj.hasCompletedElementsInOrder(this.getProcessInstanceKey(), this.toElementSelectors(elementIds));
        return this;
    }

    @Override
    public ProcessInstanceAssert hasCompletedElementsInOrder(ElementSelector ... elementSelectors) {
        this.elementAssertj.hasCompletedElementsInOrder(this.getProcessInstanceKey(), Arrays.asList(elementSelectors));
        return this;
    }

    @Override
    public ProcessInstanceAssert hasTerminatedElements(String ... elementIds) {
        this.elementAssertj.hasTerminatedElements(this.getProcessInstanceKey(), this.toElementSelectors(elementIds));
        return this;
    }

    @Override
    public ProcessInstanceAssert hasTerminatedElements(ElementSelector ... elementSelectors) {
        this.elementAssertj.hasTerminatedElements(this.getProcessInstanceKey(), Arrays.asList(elementSelectors));
        return this;
    }

    @Override
    public ProcessInstanceAssert hasActiveElement(String elementId, int times) {
        this.elementAssertj.hasActiveElement(this.getProcessInstanceKey(), this.elementSelector.apply(elementId), times);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasActiveElement(ElementSelector elementSelector, int times) {
        this.elementAssertj.hasActiveElement(this.getProcessInstanceKey(), elementSelector, times);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasCompletedElement(String elementId, int times) {
        this.elementAssertj.hasCompletedElement(this.getProcessInstanceKey(), this.elementSelector.apply(elementId), times);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasCompletedElement(ElementSelector elementSelector, int times) {
        this.elementAssertj.hasCompletedElement(this.getProcessInstanceKey(), elementSelector, times);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasTerminatedElement(String elementId, int times) {
        this.elementAssertj.hasTerminatedElement(this.getProcessInstanceKey(), this.elementSelector.apply(elementId), times);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasTerminatedElement(ElementSelector elementSelector, int times) {
        this.elementAssertj.hasTerminatedElement(this.getProcessInstanceKey(), elementSelector, times);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasNotActivatedElements(String ... elementIds) {
        this.elementAssertj.hasNotActivatedElements(this.getProcessInstanceKey(), this.toElementSelectors(elementIds));
        return this;
    }

    @Override
    public ProcessInstanceAssert hasNotActivatedElements(ElementSelector ... elementSelectors) {
        this.elementAssertj.hasNotActivatedElements(this.getProcessInstanceKey(), Arrays.asList(elementSelectors));
        return this;
    }

    @Override
    public ProcessInstanceAssert hasNoActiveElements(String ... elementIds) {
        this.elementAssertj.hasNoActiveElements(this.getProcessInstanceKey(), this.toElementSelectors(elementIds));
        return this;
    }

    @Override
    public ProcessInstanceAssert hasNoActiveElements(ElementSelector ... elementSelectors) {
        this.elementAssertj.hasNoActiveElements(this.getProcessInstanceKey(), Arrays.asList(elementSelectors));
        return this;
    }

    @Override
    public ProcessInstanceAssert hasActiveElementsExactly(String ... elementIds) {
        this.elementAssertj.hasActiveElementsExactly(this.getProcessInstanceKey(), this.toElementSelectors(elementIds));
        return this;
    }

    @Override
    public ProcessInstanceAssert hasActiveElementsExactly(ElementSelector ... elementSelectors) {
        this.elementAssertj.hasActiveElementsExactly(this.getProcessInstanceKey(), Arrays.asList(elementSelectors));
        return this;
    }

    @Override
    public ProcessInstanceAssert hasVariableNames(String ... variableNames) {
        this.variableAssertj.hasVariableNames(this.getProcessInstanceKey(), variableNames);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasVariable(String variableName, Object variableValue) {
        this.variableAssertj.hasVariable(this.getProcessInstanceKey(), variableName, variableValue);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasVariables(Map<String, Object> variables) {
        this.variableAssertj.hasVariables(this.getProcessInstanceKey(), variables);
        return this;
    }

    @Override
    public ProcessInstanceAssert hasNoActiveIncidents() {
        this.incidentAssertj.hasNoActiveIncidents(this.getProcessInstanceKey());
        return this;
    }

    @Override
    public ProcessInstanceAssert hasActiveIncidents() {
        this.incidentAssertj.hasActiveIncidents(this.getProcessInstanceKey());
        return this;
    }

    private void hasProcessInstanceInState(String expectedState, Predicate<ProcessInstanceState> expectedStateMatcher, Predicate<ProcessInstance> waitCondition) {
        this.actualProcessInstance.set(null);
        try {
            Awaitility.await().ignoreException(ClientException.class).failFast(() -> waitCondition.test(this.actualProcessInstance.get())).untilAsserted(() -> {
                Optional<ProcessInstance> processInstance = this.findProcessInstance();
                processInstance.ifPresent(this.actualProcessInstance::set);
                Assertions.assertThat(processInstance).isPresent();
                Assertions.assertThat((Comparable)processInstance.get().getState()).matches(expectedStateMatcher);
            });
        }
        catch (ConditionTimeoutException | TerminalFailureException e) {
            String actualState = Optional.ofNullable(this.actualProcessInstance.get()).map(ProcessInstance::getState).map(ProcessInstanceAssertj::formatState).orElse("not created");
            String failureMessage = String.format("%s should be %s but was %s.", this.failureMessagePrefix, expectedState, actualState);
            Assertions.fail((String)failureMessage);
        }
    }

    private Optional<ProcessInstance> findProcessInstance() {
        return this.dataSource.findProcessInstances(((ProcessInstanceSelector)this.actual)::applyFilter).stream().filter(((ProcessInstanceSelector)this.actual)::test).findFirst();
    }

    private void awaitProcessInstance() {
        try {
            Awaitility.await().ignoreException(ClientException.class).untilAsserted(() -> {
                Optional<ProcessInstance> processInstance = this.findProcessInstance();
                processInstance.ifPresent(this.actualProcessInstance::set);
                Assertions.assertThat(processInstance).isPresent();
            });
        }
        catch (ConditionTimeoutException | TerminalFailureException e) {
            String failureMessage = String.format("No process instance [%s] found.", ((ProcessInstanceSelector)this.actual).describe());
            Assertions.fail((String)failureMessage);
        }
    }

    private long getProcessInstanceKey() {
        if (this.actualProcessInstance.get() == null) {
            this.awaitProcessInstance();
        }
        return this.actualProcessInstance.get().getProcessInstanceKey();
    }

    private static boolean isEnded(ProcessInstance processInstance) {
        return processInstance != null && processInstance.getEndDate() != null;
    }

    private static String formatState(ProcessInstanceState state) {
        if (state == null || state == ProcessInstanceState.UNKNOWN_ENUM_VALUE) {
            return "not created";
        }
        return state.name().toLowerCase();
    }

    private List<ElementSelector> toElementSelectors(String[] elementIds) {
        return Arrays.stream(elementIds).map(this.elementSelector).collect(Collectors.toList());
    }
}

