/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.assertions;

import com.fasterxml.jackson.databind.JsonNode;
import io.camunda.process.test.impl.assertions.AssertFormatUtil;
import io.camunda.process.test.impl.assertions.CamundaDataSource;
import io.camunda.process.test.impl.assertions.util.AssertionJsonMapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.awaitility.core.TerminalFailureException;

public class VariableAssertj
extends AbstractAssert<VariableAssertj, String> {
    private final CamundaDataSource dataSource;

    public VariableAssertj(CamundaDataSource dataSource, String failureMessagePrefix) {
        super((Object)failureMessagePrefix, VariableAssertj.class);
        this.dataSource = dataSource;
    }

    public void hasVariableNames(long processInstanceKey, String ... variableNames) {
        AtomicReference reference = new AtomicReference(Collections.emptyMap());
        try {
            Awaitility.await().untilAsserted(() -> {
                Map<String, String> variables = this.getProcessInstanceVariables(processInstanceKey);
                reference.set(variables);
                Assertions.assertThat(variables).containsKeys((Object[])variableNames);
            });
        }
        catch (ConditionTimeoutException | TerminalFailureException e) {
            Map actualVariables = reference.get();
            List<String> missingVariableNames = Arrays.stream(variableNames).filter(variableName -> !actualVariables.containsKey(variableName)).collect(Collectors.toList());
            String failureMessage = String.format("%s should have the variables %s but %s don't exist.", this.actual, AssertFormatUtil.formatNames(variableNames), AssertFormatUtil.formatNames(missingVariableNames));
            Assertions.fail((String)failureMessage);
        }
    }

    public void hasVariable(long processInstanceKey, String variableName, Object variableValue) {
        JsonNode expectedValue = AssertionJsonMapper.toJson(variableValue);
        AtomicReference reference = new AtomicReference(Collections.emptyMap());
        try {
            Awaitility.await().untilAsserted(() -> {
                Map<String, String> variables = this.getProcessInstanceVariables(processInstanceKey);
                reference.set(variables);
                Assertions.assertThat(variables).containsKey((Object)variableName);
                JsonNode actualValue = AssertionJsonMapper.readJson(variables.get(variableName));
                Assertions.assertThat((Iterable)actualValue).isEqualTo((Object)expectedValue);
            });
        }
        catch (ConditionTimeoutException | TerminalFailureException e) {
            Map actualVariables = reference.get();
            String failureReason = Optional.ofNullable((String)actualVariables.get(variableName)).map(value -> String.format("was '%s'", value)).orElse("the variable doesn't exist");
            String failureMessage = String.format("%s should have a variable '%s' with value '%s' but %s.", this.actual, variableName, expectedValue, failureReason);
            Assertions.fail((String)failureMessage);
        }
    }

    public void hasVariables(long processInstanceKey, Map<String, Object> expectedVariables) {
        Map<String, JsonNode> expectedValues = expectedVariables.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> AssertionJsonMapper.toJson(entry.getValue())));
        Set<String> expectedVariableNames = expectedVariables.keySet();
        AtomicReference reference = new AtomicReference(Collections.emptyMap());
        try {
            Awaitility.await().untilAsserted(() -> {
                Map<String, JsonNode> actualValues = this.getProcessInstanceVariables(processInstanceKey).entrySet().stream().filter(entry -> expectedVariableNames.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, entry -> AssertionJsonMapper.readJson((String)entry.getValue())));
                reference.set(actualValues);
                Assertions.assertThat(actualValues).containsAllEntriesOf(expectedValues);
            });
        }
        catch (ConditionTimeoutException | TerminalFailureException e) {
            Map actualVariables = reference.get();
            List<String> missingVariables = expectedVariableNames.stream().filter(variableName -> !actualVariables.containsKey(variableName)).collect(Collectors.toList());
            String formattedMissingVariables = "";
            if (!missingVariables.isEmpty()) {
                formattedMissingVariables = String.format(" The variables %s don't exist.", AssertFormatUtil.formatNames(missingVariables));
            }
            String failureMessage = String.format("%s should have the variables %s but was %s.%s", this.actual, AssertionJsonMapper.toJson(expectedVariables), AssertionJsonMapper.toJson(actualVariables), formattedMissingVariables);
            Assertions.fail((String)failureMessage);
        }
    }

    private Map<String, String> getProcessInstanceVariables(long processInstanceKey) {
        return this.dataSource.findGlobalVariablesByProcessInstanceKey(processInstanceKey).stream().collect(HashMap::new, (m, v) -> m.put(v.getName(), v.getValue()), HashMap::putAll);
    }
}

