/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.assertions.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;

public class AssertionJsonMapper {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();

    public static JsonNode readJson(String value) {
        if (value == null) {
            return NullNode.getInstance();
        }
        try {
            return (JsonNode)JSON_MAPPER.readValue(value, JsonNode.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(String.format("Failed to read JSON: '%s'", value), e);
        }
    }

    public static JsonNode toJson(Object value) {
        try {
            return (JsonNode)JSON_MAPPER.convertValue(value, JsonNode.class);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(String.format("Failed to transform value to JSON: '%s'", value), e);
        }
    }
}

