/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.process.test.impl.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.process.test.impl.client.HttpClientUtil;
import io.camunda.process.test.impl.client.clock.CamundaAddClockRequestDto;
import io.camunda.process.test.impl.client.clock.CamundaClockResponseDto;
import io.camunda.process.test.impl.client.purge.MinimalPlannedOperationsResponseDto;
import io.camunda.process.test.impl.client.purge.MinimalTopologyResponseDto;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.entity.HttpEntities;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;

public class CamundaManagementClient {
    private static final String CLOCK_ENDPOINT = "/actuator/clock";
    private static final String CLOCK_ADD_ENDPOINT = "/actuator/clock/add";
    private static final String TOPOLOGY_ENDPOINT = "/v2/topology";
    private static final String CLUSTER_PURGE_ENDPOINT = "/actuator/cluster/purge";
    private final ObjectMapper objectMapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private final CloseableHttpClient httpClient = HttpClients.createDefault();
    private final URI camundaManagementApi;
    private final URI camundaRestApi;

    public CamundaManagementClient(URI camundaManagementApi, URI camundaRestApi) {
        this.camundaManagementApi = camundaManagementApi;
        this.camundaRestApi = camundaRestApi;
    }

    public Instant getCurrentTime() {
        try {
            HttpGet request = new HttpGet(this.camundaManagementApi + CLOCK_ENDPOINT);
            CamundaClockResponseDto clockResponseDto = this.sendRequest((ClassicHttpRequest)request, CamundaClockResponseDto.class);
            return Instant.parse(clockResponseDto.getInstant());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to resolve the current time", e);
        }
    }

    public void increaseTime(Duration timeToAdd) {
        HttpPost request = new HttpPost(this.camundaManagementApi + CLOCK_ADD_ENDPOINT);
        CamundaAddClockRequestDto requestDto = new CamundaAddClockRequestDto();
        requestDto.setOffsetMilli(timeToAdd.toMillis());
        try {
            String requestBody = this.objectMapper.writeValueAsString((Object)requestDto);
            request.setEntity(HttpEntities.create((String)requestBody, (ContentType)ContentType.APPLICATION_JSON));
            this.sendRequest((ClassicHttpRequest)request);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to increase the time", e);
        }
    }

    public void resetTime() {
        HttpDelete request = new HttpDelete(this.camundaManagementApi + CLOCK_ENDPOINT);
        try {
            this.sendRequest((ClassicHttpRequest)request);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to reset the time", e);
        }
    }

    public void purgeCluster() {
        this.purgeCluster(Duration.ofSeconds(30L));
    }

    public void purgeCluster(Duration timeout) {
        MinimalPlannedOperationsResponseDto startPurgeResponse = this.startPurge();
        try {
            Awaitility.await().pollInterval(Duration.ofMillis(250L)).atMost(timeout).until(() -> this.isPurgeComplete(startPurgeResponse.getChangeId()));
        }
        catch (ConditionTimeoutException e) {
            throw new RuntimeException("Failed to purge the cluster, timeout expired.", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to purge the cluster.", e);
        }
    }

    private MinimalPlannedOperationsResponseDto startPurge() {
        HttpPost purgeRequest = new HttpPost(this.camundaManagementApi + CLUSTER_PURGE_ENDPOINT);
        try {
            return this.sendRequest((ClassicHttpRequest)purgeRequest, MinimalPlannedOperationsResponseDto.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to initiate cluster purge", e);
        }
    }

    private boolean isPurgeComplete(long changeId) {
        HttpGet clusterStatusRequest = new HttpGet(this.camundaRestApi + TOPOLOGY_ENDPOINT);
        try {
            MinimalTopologyResponseDto minimalTopologyResponse = this.sendRequest((ClassicHttpRequest)clusterStatusRequest, MinimalTopologyResponseDto.class);
            return minimalTopologyResponse.isTopologyChangeCompleted(changeId);
        }
        catch (IOException e) {
            return false;
        }
    }

    private <T> T sendRequest(ClassicHttpRequest request, Class<T> clazz) throws IOException {
        return (T)this.objectMapper.readValue(this.sendRequest(request), clazz);
    }

    private String sendRequest(ClassicHttpRequest request) throws IOException {
        return (String)this.httpClient.execute(request, response -> {
            if (this.isNotSuccessfulStatusCode(response.getCode())) {
                throw new RuntimeException(String.format("Request failed. [code: %d, message: %s]", response.getCode(), HttpClientUtil.getReponseAsString(response)));
            }
            return HttpClientUtil.getReponseAsString(response);
        });
    }

    private boolean isNotSuccessfulStatusCode(int statusCode) {
        return statusCode < 200 || statusCode >= 300;
    }
}

